/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BulkheadMetrics
implements MetricSet {
    private MetricRegistry metricRegistry;

    private BulkheadMetrics(Iterable<Bulkhead> bulkheads) {
        this("resilience4j.bulkhead", bulkheads, new MetricRegistry());
    }

    private BulkheadMetrics(String prefix, Iterable<Bulkhead> bulkheads, MetricRegistry metricRegistry) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(bulkheads);
        Objects.requireNonNull(metricRegistry);
        this.metricRegistry = metricRegistry;
        bulkheads.forEach(bulkhead -> {
            String name = bulkhead.getName();
            metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, "available_concurrent_calls"}), (Metric)((Gauge)() -> bulkhead.getMetrics().getAvailableConcurrentCalls()));
            metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, "max_allowed_concurrent_calls"}), (Metric)((Gauge)() -> bulkhead.getMetrics().getMaxAllowedConcurrentCalls()));
        });
    }

    public static BulkheadMetrics ofBulkheadRegistry(String prefix, BulkheadRegistry bulkheadRegistry, MetricRegistry metricRegistry) {
        return new BulkheadMetrics(prefix, bulkheadRegistry.getAllBulkheads(), metricRegistry);
    }

    public static BulkheadMetrics ofBulkheadRegistry(String prefix, BulkheadRegistry bulkheadRegistry) {
        return new BulkheadMetrics(prefix, bulkheadRegistry.getAllBulkheads(), new MetricRegistry());
    }

    public static BulkheadMetrics ofBulkheadRegistry(BulkheadRegistry bulkheadRegistry, MetricRegistry metricRegistry) {
        return new BulkheadMetrics("resilience4j.bulkhead", bulkheadRegistry.getAllBulkheads(), metricRegistry);
    }

    public static BulkheadMetrics ofBulkheadRegistry(BulkheadRegistry bulkheadRegistry) {
        return new BulkheadMetrics(bulkheadRegistry.getAllBulkheads());
    }

    public static BulkheadMetrics ofIterable(Iterable<Bulkhead> bulkheads) {
        return new BulkheadMetrics(bulkheads);
    }

    public static BulkheadMetrics ofIterable(String prefix, Iterable<Bulkhead> bulkheads) {
        return new BulkheadMetrics(prefix, bulkheads, new MetricRegistry());
    }

    public static BulkheadMetrics ofBulkhead(Bulkhead bulkhead) {
        return new BulkheadMetrics(List.of(bulkhead));
    }

    public Map<String, Metric> getMetrics() {
        return this.metricRegistry.getMetrics();
    }
}

