/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.metrics.publisher;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.metrics.publisher.AbstractMetricsPublisher;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class CircuitBreakerMetricsPublisher
extends AbstractMetricsPublisher<CircuitBreaker> {
    private final String prefix;

    public CircuitBreakerMetricsPublisher() {
        this("resilience4j.circuitbreaker", new MetricRegistry());
    }

    public CircuitBreakerMetricsPublisher(MetricRegistry metricRegistry) {
        this("resilience4j.circuitbreaker", metricRegistry);
    }

    public CircuitBreakerMetricsPublisher(String prefix, MetricRegistry metricRegistry) {
        super(metricRegistry);
        this.prefix = Objects.requireNonNull(prefix);
    }

    public void publishMetrics(CircuitBreaker circuitBreaker) {
        String name = circuitBreaker.getName();
        String state = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "state"});
        String successful = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "successful"});
        String failed = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "failed"});
        String slow = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "slow"});
        String slowSuccess = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "slow_successful"});
        String slowFailed = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "slow_failed"});
        String notPermitted = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "not_permitted"});
        String numberOfBufferedCalls = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "buffered"});
        String failureRate = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "failure_rate"});
        String slowCallRate = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "slow_call_rate"});
        this.metricRegistry.register(state, (Metric)((Gauge)() -> circuitBreaker.getState().getOrder()));
        this.metricRegistry.register(successful, (Metric)((Gauge)() -> circuitBreaker.getMetrics().getNumberOfSuccessfulCalls()));
        this.metricRegistry.register(failed, (Metric)((Gauge)() -> circuitBreaker.getMetrics().getNumberOfFailedCalls()));
        this.metricRegistry.register(slow, (Metric)((Gauge)() -> circuitBreaker.getMetrics().getNumberOfSlowCalls()));
        this.metricRegistry.register(slowSuccess, (Metric)((Gauge)() -> circuitBreaker.getMetrics().getNumberOfSlowCalls()));
        this.metricRegistry.register(slowFailed, (Metric)((Gauge)() -> circuitBreaker.getMetrics().getNumberOfSlowFailedCalls()));
        this.metricRegistry.register(notPermitted, (Metric)((Gauge)() -> circuitBreaker.getMetrics().getNumberOfNotPermittedCalls()));
        this.metricRegistry.register(numberOfBufferedCalls, (Metric)((Gauge)() -> circuitBreaker.getMetrics().getNumberOfBufferedCalls()));
        this.metricRegistry.register(failureRate, (Metric)((Gauge)() -> Float.valueOf(circuitBreaker.getMetrics().getFailureRate())));
        this.metricRegistry.register(slowCallRate, (Metric)((Gauge)() -> Float.valueOf(circuitBreaker.getMetrics().getSlowCallRate())));
        List<String> metricNames = Arrays.asList(state, successful, failed, notPermitted, numberOfBufferedCalls, failureRate, slow, slowSuccess, slowFailed, slowCallRate);
        this.metricsNameMap.put(name, new HashSet<String>(metricNames));
    }

    public void removeMetrics(CircuitBreaker circuitBreaker) {
        this.removeMetrics(circuitBreaker.getName());
    }
}

