/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadRegistry;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ThreadPoolBulkheadMetrics
implements MetricSet {
    private final MetricRegistry metricRegistry;

    private ThreadPoolBulkheadMetrics(Iterable<ThreadPoolBulkhead> bulkheads) {
        this("resilience4j.thread_pool_bulkhead", bulkheads, new MetricRegistry());
    }

    private ThreadPoolBulkheadMetrics(String prefix, Iterable<ThreadPoolBulkhead> bulkheads, MetricRegistry metricRegistry) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(bulkheads);
        Objects.requireNonNull(metricRegistry);
        this.metricRegistry = metricRegistry;
        bulkheads.forEach(bulkhead -> {
            String name = bulkhead.getName();
            metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, "current_thread_pool_size"}), (Metric)((Gauge)() -> bulkhead.getMetrics().getThreadPoolSize()));
            metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, "available_queue_capacity"}), (Metric)((Gauge)() -> bulkhead.getMetrics().getRemainingQueueCapacity()));
        });
    }

    public static ThreadPoolBulkheadMetrics ofBulkheadRegistry(String prefix, ThreadPoolBulkheadRegistry bulkheadRegistry, MetricRegistry metricRegistry) {
        return new ThreadPoolBulkheadMetrics(prefix, bulkheadRegistry.getAllBulkheads(), metricRegistry);
    }

    public static ThreadPoolBulkheadMetrics ofBulkheadRegistry(String prefix, ThreadPoolBulkheadRegistry bulkheadRegistry) {
        return new ThreadPoolBulkheadMetrics(prefix, bulkheadRegistry.getAllBulkheads(), new MetricRegistry());
    }

    public static ThreadPoolBulkheadMetrics ofBulkheadRegistry(ThreadPoolBulkheadRegistry bulkheadRegistry, MetricRegistry metricRegistry) {
        return new ThreadPoolBulkheadMetrics("resilience4j.bulkhead", bulkheadRegistry.getAllBulkheads(), metricRegistry);
    }

    public static ThreadPoolBulkheadMetrics ofBulkheadRegistry(ThreadPoolBulkheadRegistry bulkheadRegistry) {
        return new ThreadPoolBulkheadMetrics(bulkheadRegistry.getAllBulkheads());
    }

    public static ThreadPoolBulkheadMetrics ofIterable(Iterable<ThreadPoolBulkhead> bulkheads) {
        return new ThreadPoolBulkheadMetrics(bulkheads);
    }

    public static ThreadPoolBulkheadMetrics ofIterable(String prefix, Iterable<ThreadPoolBulkhead> bulkheads) {
        return new ThreadPoolBulkheadMetrics(prefix, bulkheads, new MetricRegistry());
    }

    public static ThreadPoolBulkheadMetrics ofBulkhead(ThreadPoolBulkhead bulkhead) {
        return new ThreadPoolBulkheadMetrics(List.of(bulkhead));
    }

    public Map<String, Metric> getMetrics() {
        return this.metricRegistry.getMetrics();
    }
}

