/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.metrics.publisher;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import io.github.resilience4j.metrics.publisher.AbstractMetricsPublisher;
import io.github.resilience4j.ratelimiter.RateLimiter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class RateLimiterMetricsPublisher
extends AbstractMetricsPublisher<RateLimiter> {
    private final String prefix;

    public RateLimiterMetricsPublisher() {
        this("resilience4j.ratelimiter", new MetricRegistry());
    }

    public RateLimiterMetricsPublisher(MetricRegistry metricRegistry) {
        this("resilience4j.ratelimiter", metricRegistry);
    }

    public RateLimiterMetricsPublisher(String prefix, MetricRegistry metricRegistry) {
        super(metricRegistry);
        this.prefix = Objects.requireNonNull(prefix);
    }

    public void publishMetrics(RateLimiter rateLimiter) {
        String name = rateLimiter.getName();
        String waitingThreads = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "number_of_waiting_threads"});
        String availablePermissions = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "available_permissions"});
        this.metricRegistry.register(waitingThreads, (Metric)((Gauge)() -> ((RateLimiter.Metrics)rateLimiter.getMetrics()).getNumberOfWaitingThreads()));
        this.metricRegistry.register(availablePermissions, (Metric)((Gauge)() -> ((RateLimiter.Metrics)rateLimiter.getMetrics()).getAvailablePermissions()));
        List<String> metricNames = Arrays.asList(waitingThreads, availablePermissions);
        this.metricsNameMap.put(name, new HashSet<String>(metricNames));
    }

    public void removeMetrics(RateLimiter rateLimiter) {
        this.removeMetrics(rateLimiter.getName());
    }
}

