/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryRegistry;
import io.vavr.collection.Array;
import java.util.Map;
import java.util.Objects;

public class RetryMetrics
implements MetricSet {
    private final MetricRegistry metricRegistry;

    private RetryMetrics(Iterable<Retry> retries) {
        this("resilience4j.retry", retries, new MetricRegistry());
    }

    private RetryMetrics(String prefix, Iterable<Retry> retries, MetricRegistry metricRegistry) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(retries);
        Objects.requireNonNull(metricRegistry);
        this.metricRegistry = metricRegistry;
        retries.forEach(retry -> {
            String name = retry.getName();
            metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, "successful_calls_without_retry"}), (Metric)((Gauge)() -> retry.getMetrics().getNumberOfSuccessfulCallsWithoutRetryAttempt()));
            metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, "successful_calls_with_retry"}), (Metric)((Gauge)() -> retry.getMetrics().getNumberOfSuccessfulCallsWithRetryAttempt()));
            metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, "failed_calls_without_retry"}), (Metric)((Gauge)() -> retry.getMetrics().getNumberOfFailedCallsWithoutRetryAttempt()));
            metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, "failed_calls_with_retry"}), (Metric)((Gauge)() -> retry.getMetrics().getNumberOfFailedCallsWithRetryAttempt()));
        });
    }

    public static RetryMetrics ofRetryRegistry(String prefix, RetryRegistry retryRegistry, MetricRegistry metricRegistry) {
        return new RetryMetrics(prefix, (Iterable<Retry>)retryRegistry.getAllRetries(), metricRegistry);
    }

    public static RetryMetrics ofRetryRegistry(String prefix, RetryRegistry retryRegistry) {
        return new RetryMetrics(prefix, (Iterable<Retry>)retryRegistry.getAllRetries(), new MetricRegistry());
    }

    public static RetryMetrics ofRetryRegistry(RetryRegistry retryRegistry, MetricRegistry metricRegistry) {
        return new RetryMetrics("resilience4j.retry", (Iterable<Retry>)retryRegistry.getAllRetries(), metricRegistry);
    }

    public static RetryMetrics ofRetryRegistry(RetryRegistry retryRegistry) {
        return new RetryMetrics((Iterable<Retry>)retryRegistry.getAllRetries());
    }

    public static RetryMetrics ofIterable(String prefix, Iterable<Retry> retries) {
        return new RetryMetrics(prefix, retries, new MetricRegistry());
    }

    public static RetryMetrics ofIterable(Iterable<Retry> retries) {
        return new RetryMetrics(retries);
    }

    public static RetryMetrics ofRetry(Retry retry) {
        return new RetryMetrics((Iterable<Retry>)Array.of((Object)retry));
    }

    public Map<String, Metric> getMetrics() {
        return this.metricRegistry.getMetrics();
    }
}

