/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.vavr.collection.Array;
import java.util.Map;
import java.util.Objects;

public class CircuitBreakerMetrics
implements MetricSet {
    private final MetricRegistry metricRegistry;

    private CircuitBreakerMetrics(Iterable<CircuitBreaker> circuitBreakers) {
        this("resilience4j.circuitbreaker", circuitBreakers, new MetricRegistry());
    }

    private CircuitBreakerMetrics(String prefix, Iterable<CircuitBreaker> circuitBreakers, MetricRegistry metricRegistry) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(circuitBreakers);
        Objects.requireNonNull(metricRegistry);
        this.metricRegistry = metricRegistry;
        circuitBreakers.forEach(circuitBreaker -> {
            String name = circuitBreaker.getName();
            metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, "state"}), (Metric)((Gauge)() -> circuitBreaker.getState().getOrder()));
            metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, "successful"}), (Metric)((Gauge)() -> circuitBreaker.getMetrics().getNumberOfSuccessfulCalls()));
            metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, "failed"}), (Metric)((Gauge)() -> circuitBreaker.getMetrics().getNumberOfFailedCalls()));
            metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, "not_permitted"}), (Metric)((Gauge)() -> circuitBreaker.getMetrics().getNumberOfNotPermittedCalls()));
            metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, "buffered"}), (Metric)((Gauge)() -> circuitBreaker.getMetrics().getNumberOfBufferedCalls()));
            metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, "failure_rate"}), (Metric)((Gauge)() -> Float.valueOf(circuitBreaker.getMetrics().getFailureRate())));
        });
    }

    public static CircuitBreakerMetrics ofCircuitBreakerRegistry(String prefix, CircuitBreakerRegistry circuitBreakerRegistry, MetricRegistry metricRegistry) {
        return new CircuitBreakerMetrics(prefix, (Iterable<CircuitBreaker>)circuitBreakerRegistry.getAllCircuitBreakers(), metricRegistry);
    }

    public static CircuitBreakerMetrics ofCircuitBreakerRegistry(String prefix, CircuitBreakerRegistry circuitBreakerRegistry) {
        return new CircuitBreakerMetrics(prefix, (Iterable<CircuitBreaker>)circuitBreakerRegistry.getAllCircuitBreakers(), new MetricRegistry());
    }

    public static CircuitBreakerMetrics ofCircuitBreakerRegistry(CircuitBreakerRegistry circuitBreakerRegistry, MetricRegistry metricRegistry) {
        return new CircuitBreakerMetrics("resilience4j.circuitbreaker", (Iterable<CircuitBreaker>)circuitBreakerRegistry.getAllCircuitBreakers(), metricRegistry);
    }

    public static CircuitBreakerMetrics ofCircuitBreakerRegistry(CircuitBreakerRegistry circuitBreakerRegistry) {
        return new CircuitBreakerMetrics((Iterable<CircuitBreaker>)circuitBreakerRegistry.getAllCircuitBreakers());
    }

    public static CircuitBreakerMetrics ofIterable(Iterable<CircuitBreaker> circuitBreakers) {
        return new CircuitBreakerMetrics(circuitBreakers);
    }

    public static CircuitBreakerMetrics ofIterable(String prefix, Iterable<CircuitBreaker> circuitBreakers) {
        return new CircuitBreakerMetrics(prefix, circuitBreakers, new MetricRegistry());
    }

    public static CircuitBreakerMetrics ofCircuitBreaker(CircuitBreaker circuitBreaker) {
        return new CircuitBreakerMetrics((Iterable<CircuitBreaker>)Array.of((Object)circuitBreaker));
    }

    public Map<String, Metric> getMetrics() {
        return this.metricRegistry.getMetrics();
    }
}

