/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.vavr.collection.Array;
import java.util.Map;
import java.util.Objects;

public class BulkheadMetrics
implements MetricSet {
    private final MetricRegistry metricRegistry = new MetricRegistry();

    private BulkheadMetrics(Iterable<Bulkhead> bulkheads) {
        this("resilience4j.bulkhead", bulkheads);
    }

    private BulkheadMetrics(String prefix, Iterable<Bulkhead> bulkheads) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(bulkheads);
        bulkheads.forEach(bulkhead -> {
            String name = bulkhead.getName();
            this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, "available_concurrent_calls"}), (Metric)((Gauge)() -> bulkhead.getMetrics().getAvailableConcurrentCalls()));
            this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, "max_allowed_concurrent_calls"}), (Metric)((Gauge)() -> bulkhead.getMetrics().getMaxAllowedConcurrentCalls()));
        });
    }

    public static BulkheadMetrics ofBulkheadRegistry(String prefix, BulkheadRegistry bulkheadRegistry) {
        return new BulkheadMetrics(prefix, (Iterable<Bulkhead>)bulkheadRegistry.getAllBulkheads());
    }

    public static BulkheadMetrics ofBulkheadRegistry(BulkheadRegistry bulkheadRegistry) {
        return new BulkheadMetrics((Iterable<Bulkhead>)bulkheadRegistry.getAllBulkheads());
    }

    public static BulkheadMetrics ofIterable(Iterable<Bulkhead> bulkheads) {
        return new BulkheadMetrics(bulkheads);
    }

    public static BulkheadMetrics ofIterable(String prefix, Iterable<Bulkhead> bulkheads) {
        return new BulkheadMetrics(prefix, bulkheads);
    }

    public static BulkheadMetrics ofBulkhead(Bulkhead bulkhead) {
        return new BulkheadMetrics((Iterable<Bulkhead>)Array.of((Object)bulkhead));
    }

    public Map<String, Metric> getMetrics() {
        return this.metricRegistry.getMetrics();
    }
}

