/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import io.github.resilience4j.metrics.internal.TimerImpl;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedRunnable;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Timer {
    public Context context();

    public String getName();

    public MetricRegistry getMetricRegistry();

    public Metrics getMetrics();

    public static Timer ofMetricRegistry(String name, MetricRegistry metricRegistry) {
        return new TimerImpl(name, metricRegistry);
    }

    public static Timer of(String name) {
        return new TimerImpl(name, new MetricRegistry());
    }

    default public void executeRunnable(Runnable runnable) throws Exception {
        Timer.decorateRunnable(this, runnable).run();
    }

    default public <T> T executeCallable(Callable<T> callable) throws Exception {
        return Timer.decorateCallable(this, callable).call();
    }

    default public <T> T executeSupplier(Supplier<T> supplier) {
        return Timer.decorateSupplier(this, supplier).get();
    }

    default public <T> CompletionStage<T> executeCompletionStageSupplier(Supplier<CompletionStage<T>> supplier) {
        return Timer.decorateCompletionStageSupplier(this, supplier).get();
    }

    public static <T> CheckedFunction0<T> decorateCheckedSupplier(Timer timer, CheckedFunction0<T> supplier) {
        return (CheckedFunction0 & Serializable)() -> {
            Context context = timer.context();
            try {
                Object returnValue = supplier.apply();
                context.onSuccess();
                return returnValue;
            }
            catch (Throwable e) {
                context.onError();
                throw e;
            }
        };
    }

    public static CheckedRunnable decorateCheckedRunnable(Timer timer, CheckedRunnable runnable) {
        return () -> {
            Context context = timer.context();
            try {
                runnable.run();
                context.onSuccess();
            }
            catch (Throwable e) {
                context.onError();
                throw e;
            }
        };
    }

    public static <T> Supplier<T> decorateSupplier(Timer timer, Supplier<T> supplier) {
        return () -> {
            Context context = timer.context();
            try {
                Object returnValue = supplier.get();
                context.onSuccess();
                return returnValue;
            }
            catch (Throwable e) {
                context.onError();
                throw e;
            }
        };
    }

    public static <T> Callable<T> decorateCallable(Timer timer, Callable<T> callable) {
        return () -> {
            Context context = timer.context();
            try {
                Object returnValue = callable.call();
                context.onSuccess();
                return returnValue;
            }
            catch (Throwable e) {
                context.onError();
                throw e;
            }
        };
    }

    public static Runnable decorateRunnable(Timer timer, Runnable runnable) {
        return () -> {
            Context context = timer.context();
            try {
                runnable.run();
                context.onSuccess();
            }
            catch (Throwable e) {
                context.onError();
                throw e;
            }
        };
    }

    public static <T, R> Function<T, R> decorateFunction(Timer timer, Function<T, R> function) {
        return t -> {
            Context context = timer.context();
            try {
                Object returnValue = function.apply(t);
                context.onSuccess();
                return returnValue;
            }
            catch (Throwable e) {
                context.onError();
                throw e;
            }
        };
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(Timer timer, CheckedFunction1<T, R> function) {
        return (CheckedFunction1 & Serializable)t -> {
            Context context = timer.context();
            try {
                Object returnValue = function.apply(t);
                context.onSuccess();
                return returnValue;
            }
            catch (Throwable e) {
                context.onError();
                throw e;
            }
        };
    }

    public static <T> Supplier<CompletionStage<T>> decorateCompletionStageSupplier(Timer timer, Supplier<CompletionStage<T>> stageSupplier) {
        return () -> {
            Context context = timer.context();
            try {
                CompletionStage stage = (CompletionStage)stageSupplier.get();
                stage.whenComplete((result, throwable) -> {
                    if (throwable != null) {
                        context.onError();
                    } else {
                        context.onSuccess();
                    }
                });
                return stage;
            }
            catch (Throwable throwable2) {
                context.onError();
                throw throwable2;
            }
        };
    }

    public static interface Metrics {
        public long getNumberOfTotalCalls();

        public long getNumberOfSuccessfulCalls();

        public long getNumberOfFailedCalls();

        public double getFifteenMinuteRate();

        public double getFiveMinuteRate();

        public double getMeanRate();

        public double getOneMinuteRate();

        public Snapshot getSnapshot();
    }

    public static interface Context {
        public void onError();

        public void onSuccess();
    }
}

