/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.RatioGauge;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryRegistry;
import io.vavr.collection.Array;
import java.util.Map;
import java.util.Objects;

public class RetryMetrics
implements MetricSet {
    public static final String SUCCESSFUL_CALLS_WITHOUT_RETRY = "successful_calls_without_retry";
    public static final String SUCCESSFUL_CALLS_WITH_RETRY = "successful_calls_with_retry";
    public static final String FAILED_CALLS_WITHOUT_RETRY = "failed_calls_without_retry";
    public static final String FAILED_CALLS_WITH_RETRY = "failed_calls_with_retry";
    private final MetricRegistry metricRegistry = new MetricRegistry();
    private static final String DEFAULT_PREFIX = "resilience4j.retry";

    private RetryMetrics(Iterable<Retry> retries) {
        this(DEFAULT_PREFIX, retries);
    }

    private RetryMetrics(String prefix, Iterable<Retry> retries) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(retries);
        retries.forEach(retry -> {
            String name = retry.getName();
            Retry.Metrics metrics = retry.getMetrics();
            this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, SUCCESSFUL_CALLS_WITHOUT_RETRY}), (Metric)((Gauge)() -> ((Retry.Metrics)metrics).getNumberOfSuccessfulCallsWithoutRetryAttempt()));
            this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, SUCCESSFUL_CALLS_WITH_RETRY}), (Metric)((Gauge)() -> ((Retry.Metrics)metrics).getNumberOfSuccessfulCallsWithRetryAttempt()));
            this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, FAILED_CALLS_WITHOUT_RETRY}), (Metric)((Gauge)() -> ((Retry.Metrics)metrics).getNumberOfFailedCallsWithoutRetryAttempt()));
            this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, FAILED_CALLS_WITH_RETRY}), (Metric)((Gauge)() -> ((Retry.Metrics)metrics).getNumberOfFailedCallsWithRetryAttempt()));
        });
    }

    public static RetryMetrics ofRetryRegistry(String prefix, RetryRegistry retryRegistry) {
        return new RetryMetrics(prefix, (Iterable<Retry>)retryRegistry.getAllRetries());
    }

    public static RetryMetrics ofRetryRegistry(RetryRegistry retryRegistry) {
        return new RetryMetrics((Iterable<Retry>)retryRegistry.getAllRetries());
    }

    public static RetryMetrics ofIterable(String prefix, Iterable<Retry> retries) {
        return new RetryMetrics(prefix, retries);
    }

    public static RetryMetrics ofIterable(Iterable<Retry> retries) {
        return new RetryMetrics(retries);
    }

    public static RetryMetrics ofRateLimiter(Retry retry) {
        return new RetryMetrics((Iterable<Retry>)Array.of((Object)retry));
    }

    public Map<String, Metric> getMetrics() {
        return this.metricRegistry.getMetrics();
    }

    private final class RetryRatio
    extends RatioGauge {
        private double numAttempts;
        private double maxAttempts;

        public RetryRatio(int numAttempts, int maxAttempts) {
            this.numAttempts = numAttempts;
            this.maxAttempts = maxAttempts;
        }

        protected RatioGauge.Ratio getRatio() {
            return RatioGauge.Ratio.of((double)this.numAttempts, (double)this.maxAttempts);
        }
    }
}

