/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.vavr.collection.Array;
import java.util.Map;
import java.util.Objects;

public class RateLimiterMetrics
implements MetricSet {
    private static final String PREFIX_NULL = "Prefix must not be null";
    private static final String ITERABLE_NULL = "RateLimiters iterable must not be null";
    private static final String DEFAULT_PREFIX = "resilience4j.ratelimiter";
    private final MetricRegistry metricRegistry = new MetricRegistry();

    private RateLimiterMetrics(Iterable<RateLimiter> rateLimiters) {
        this(DEFAULT_PREFIX, rateLimiters);
    }

    private RateLimiterMetrics(String prefix, Iterable<RateLimiter> rateLimiters) {
        Objects.requireNonNull(prefix, PREFIX_NULL);
        Objects.requireNonNull(rateLimiters, ITERABLE_NULL);
        rateLimiters.forEach(rateLimiter -> {
            String name = rateLimiter.getName();
            RateLimiter.Metrics metrics = rateLimiter.getMetrics();
            this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, "number_of_waiting_threads"}), (Metric)((Gauge)() -> ((RateLimiter.Metrics)metrics).getNumberOfWaitingThreads()));
            this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, "available_permissions"}), (Metric)((Gauge)() -> ((RateLimiter.Metrics)metrics).getAvailablePermissions()));
        });
    }

    public static RateLimiterMetrics ofRateLimiterRegistry(String prefix, RateLimiterRegistry rateLimiterRegistry) {
        return new RateLimiterMetrics(prefix, (Iterable<RateLimiter>)rateLimiterRegistry.getAllRateLimiters());
    }

    public static RateLimiterMetrics ofRateLimiterRegistry(RateLimiterRegistry rateLimiterRegistry) {
        return new RateLimiterMetrics((Iterable<RateLimiter>)rateLimiterRegistry.getAllRateLimiters());
    }

    public static RateLimiterMetrics ofIterable(Iterable<RateLimiter> rateLimiters) {
        return new RateLimiterMetrics(rateLimiters);
    }

    public static RateLimiterMetrics ofIterable(String prefix, Iterable<RateLimiter> rateLimiters) {
        return new RateLimiterMetrics(prefix, rateLimiters);
    }

    public static RateLimiterMetrics ofRateLimiter(RateLimiter rateLimiter) {
        return new RateLimiterMetrics((Iterable<RateLimiter>)Array.of((Object)rateLimiter));
    }

    public Map<String, Metric> getMetrics() {
        return this.metricRegistry.getMetrics();
    }
}

