/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.vavr.collection.Array;
import java.util.Map;
import java.util.Objects;

public class CircuitBreakerMetrics
implements MetricSet {
    private static final String DEFAULT_PREFIX = "resilience4j.circuitbreaker";
    public static final String SUCCESSFUL = "successful";
    public static final String FAILED = "failed";
    public static final String NOT_PERMITTED = "not_permitted";
    public static final String BUFFERED = "buffered";
    public static final String BUFFERED_MAX = "buffered_max";
    private final MetricRegistry metricRegistry = new MetricRegistry();

    private CircuitBreakerMetrics(Iterable<CircuitBreaker> circuitBreakers) {
        this(DEFAULT_PREFIX, circuitBreakers);
    }

    private CircuitBreakerMetrics(String prefix, Iterable<CircuitBreaker> circuitBreakers) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(circuitBreakers);
        circuitBreakers.forEach(circuitBreaker -> {
            String name = circuitBreaker.getName();
            CircuitBreaker.Metrics metrics = circuitBreaker.getMetrics();
            this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, SUCCESSFUL}), (Metric)((Gauge)() -> ((CircuitBreaker.Metrics)metrics).getNumberOfSuccessfulCalls()));
            this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, FAILED}), (Metric)((Gauge)() -> ((CircuitBreaker.Metrics)metrics).getNumberOfFailedCalls()));
            this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, NOT_PERMITTED}), (Metric)((Gauge)() -> ((CircuitBreaker.Metrics)metrics).getNumberOfNotPermittedCalls()));
            this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, BUFFERED}), (Metric)((Gauge)() -> ((CircuitBreaker.Metrics)metrics).getNumberOfBufferedCalls()));
            this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, BUFFERED_MAX}), (Metric)((Gauge)() -> ((CircuitBreaker.Metrics)metrics).getMaxNumberOfBufferedCalls()));
        });
    }

    public static CircuitBreakerMetrics ofCircuitBreakerRegistry(String prefix, CircuitBreakerRegistry circuitBreakerRegistry) {
        return new CircuitBreakerMetrics(prefix, (Iterable<CircuitBreaker>)circuitBreakerRegistry.getAllCircuitBreakers());
    }

    public static CircuitBreakerMetrics ofCircuitBreakerRegistry(CircuitBreakerRegistry circuitBreakerRegistry) {
        return new CircuitBreakerMetrics((Iterable<CircuitBreaker>)circuitBreakerRegistry.getAllCircuitBreakers());
    }

    public static CircuitBreakerMetrics ofIterable(Iterable<CircuitBreaker> circuitBreakers) {
        return new CircuitBreakerMetrics(circuitBreakers);
    }

    public static CircuitBreakerMetrics ofIterable(String prefix, Iterable<CircuitBreaker> circuitBreakers) {
        return new CircuitBreakerMetrics(prefix, circuitBreakers);
    }

    public static CircuitBreakerMetrics ofCircuitBreaker(CircuitBreaker circuitBreaker) {
        return new CircuitBreakerMetrics((Iterable<CircuitBreaker>)Array.of((Object)circuitBreaker));
    }

    public Map<String, Metric> getMetrics() {
        return this.metricRegistry.getMetrics();
    }
}

