/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.common.bulkhead.configuration;

import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.common.CommonProperties;
import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.bulkhead.configuration.BulkheadConfigCustomizer;
import io.github.resilience4j.common.utils.ConfigUtils;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.StringUtils;
import io.github.resilience4j.core.lang.Nullable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class BulkheadConfigurationProperties
extends CommonProperties {
    private Map<String, InstanceProperties> instances = new HashMap<String, InstanceProperties>();
    private Map<String, InstanceProperties> configs = new HashMap<String, InstanceProperties>();

    public BulkheadConfig createBulkheadConfig(InstanceProperties instanceProperties, CompositeCustomizer<BulkheadConfigCustomizer> compositeBulkheadCustomizer, String instanceName) {
        if (StringUtils.isNotEmpty((String)instanceProperties.getBaseConfig())) {
            InstanceProperties baseProperties = this.configs.get(instanceProperties.getBaseConfig());
            if (baseProperties == null) {
                throw new ConfigurationNotFoundException(instanceProperties.getBaseConfig());
            }
            return this.buildConfigFromBaseConfig(baseProperties, instanceProperties, compositeBulkheadCustomizer, instanceName);
        }
        return this.buildBulkheadConfig(BulkheadConfig.custom(), instanceProperties, compositeBulkheadCustomizer, instanceName);
    }

    private BulkheadConfig buildConfigFromBaseConfig(InstanceProperties baseProperties, InstanceProperties instanceProperties, CompositeCustomizer<BulkheadConfigCustomizer> compositeBulkheadCustomizer, String instanceName) {
        ConfigUtils.mergePropertiesIfAny(baseProperties, instanceProperties);
        BulkheadConfig baseConfig = this.buildBulkheadConfig(BulkheadConfig.custom(), baseProperties, compositeBulkheadCustomizer, instanceName);
        return this.buildBulkheadConfig(BulkheadConfig.from((BulkheadConfig)baseConfig), instanceProperties, compositeBulkheadCustomizer, instanceName);
    }

    private BulkheadConfig buildBulkheadConfig(BulkheadConfig.Builder builder, InstanceProperties instanceProperties, CompositeCustomizer<BulkheadConfigCustomizer> compositeBulkheadCustomizer, String instanceName) {
        if (instanceProperties.getMaxConcurrentCalls() != null) {
            builder.maxConcurrentCalls(instanceProperties.getMaxConcurrentCalls().intValue());
        }
        if (instanceProperties.getMaxWaitDuration() != null) {
            builder.maxWaitDuration(instanceProperties.getMaxWaitDuration());
        }
        compositeBulkheadCustomizer.getCustomizer(instanceName).ifPresent(bulkheadConfigCustomizer -> bulkheadConfigCustomizer.customize(builder));
        return builder.build();
    }

    @Nullable
    public InstanceProperties getBackendProperties(String backend) {
        return this.instances.get(backend);
    }

    public Map<String, InstanceProperties> getInstances() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getBackends() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getConfigs() {
        return this.configs;
    }

    public static class InstanceProperties {
        private Integer maxConcurrentCalls;
        private Duration maxWaitDuration;
        @Nullable
        private String baseConfig;
        @Nullable
        private Integer eventConsumerBufferSize;

        public Integer getMaxConcurrentCalls() {
            return this.maxConcurrentCalls;
        }

        public InstanceProperties setMaxConcurrentCalls(Integer maxConcurrentCalls) {
            Objects.requireNonNull(maxConcurrentCalls);
            if (maxConcurrentCalls < 1) {
                throw new IllegalArgumentException("maxConcurrentCalls must be greater than or equal to 1.");
            }
            this.maxConcurrentCalls = maxConcurrentCalls;
            return this;
        }

        public Duration getMaxWaitDuration() {
            return this.maxWaitDuration;
        }

        public InstanceProperties setMaxWaitDuration(Duration maxWaitDuration) {
            Objects.requireNonNull(maxWaitDuration);
            if (maxWaitDuration.toMillis() < 0L) {
                throw new IllegalArgumentException("maxWaitDuration must be greater than or equal to 0.");
            }
            this.maxWaitDuration = maxWaitDuration;
            return this;
        }

        @Nullable
        public String getBaseConfig() {
            return this.baseConfig;
        }

        public InstanceProperties setBaseConfig(String baseConfig) {
            this.baseConfig = baseConfig;
            return this;
        }

        @Nullable
        public Integer getEventConsumerBufferSize() {
            return this.eventConsumerBufferSize;
        }

        public InstanceProperties setEventConsumerBufferSize(Integer eventConsumerBufferSize) {
            Objects.requireNonNull(eventConsumerBufferSize);
            if (eventConsumerBufferSize < 1) {
                throw new IllegalArgumentException("eventConsumerBufferSize must be greater than or equal to 1.");
            }
            this.eventConsumerBufferSize = eventConsumerBufferSize;
            return this;
        }
    }
}

