/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.common.circuitbreaker.configuration;

import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.common.utils.ConfigUtils;
import io.github.resilience4j.core.ClassUtils;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.StringUtils;
import io.github.resilience4j.core.lang.Nullable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.time.DurationMin;

public class CircuitBreakerConfigurationProperties {
    private Map<String, InstanceProperties> instances = new HashMap<String, InstanceProperties>();
    private Map<String, InstanceProperties> configs = new HashMap<String, InstanceProperties>();

    public Optional<InstanceProperties> findCircuitBreakerProperties(String name) {
        return Optional.ofNullable(this.instances.get(name));
    }

    public CircuitBreakerConfig createCircuitBreakerConfig(InstanceProperties instanceProperties) {
        if (StringUtils.isNotEmpty((String)instanceProperties.getBaseConfig())) {
            InstanceProperties baseProperties = this.configs.get(instanceProperties.getBaseConfig());
            if (baseProperties == null) {
                throw new ConfigurationNotFoundException(instanceProperties.getBaseConfig());
            }
            return this.buildConfigFromBaseConfig(instanceProperties, baseProperties);
        }
        return this.buildConfig(CircuitBreakerConfig.custom(), instanceProperties);
    }

    private CircuitBreakerConfig buildConfigFromBaseConfig(InstanceProperties instanceProperties, InstanceProperties baseProperties) {
        ConfigUtils.mergePropertiesIfAny(instanceProperties, baseProperties);
        CircuitBreakerConfig baseConfig = this.buildConfig(CircuitBreakerConfig.custom(), baseProperties);
        return this.buildConfig(CircuitBreakerConfig.from((CircuitBreakerConfig)baseConfig), instanceProperties);
    }

    private CircuitBreakerConfig buildConfig(CircuitBreakerConfig.Builder builder, InstanceProperties properties) {
        if (properties == null) {
            return builder.build();
        }
        if (properties.getWaitDurationInOpenState() != null) {
            builder.waitDurationInOpenState(properties.getWaitDurationInOpenState());
        }
        if (properties.getFailureRateThreshold() != null) {
            builder.failureRateThreshold((float)properties.getFailureRateThreshold().intValue());
        }
        if (properties.getRingBufferSizeInClosedState() != null) {
            builder.ringBufferSizeInClosedState(properties.getRingBufferSizeInClosedState().intValue());
        }
        if (properties.getRingBufferSizeInHalfOpenState() != null) {
            builder.ringBufferSizeInHalfOpenState(properties.getRingBufferSizeInHalfOpenState().intValue());
        }
        if (properties.recordFailurePredicate != null) {
            this.buildRecordFailurePredicate(properties, builder);
        }
        if (properties.recordExceptions != null) {
            builder.recordExceptions(properties.recordExceptions);
        }
        if (properties.ignoreExceptions != null) {
            builder.ignoreExceptions(properties.ignoreExceptions);
        }
        if (properties.automaticTransitionFromOpenToHalfOpenEnabled != null) {
            builder.automaticTransitionFromOpenToHalfOpenEnabled(properties.automaticTransitionFromOpenToHalfOpenEnabled.booleanValue());
        }
        return builder.build();
    }

    private void buildRecordFailurePredicate(InstanceProperties properties, CircuitBreakerConfig.Builder builder) {
        Predicate predicate;
        if (properties.getRecordFailurePredicate() != null && (predicate = ClassUtils.instantiatePredicateClass(properties.getRecordFailurePredicate())) != null) {
            builder.recordFailure(predicate);
        }
    }

    @Nullable
    public InstanceProperties getBackendProperties(String backend) {
        return this.instances.get(backend);
    }

    public Map<String, InstanceProperties> getInstances() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getBackends() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getConfigs() {
        return this.configs;
    }

    public static class InstanceProperties {
        @DurationMin(seconds=1L)
        @Nullable
        private @DurationMin(seconds=1L) Duration waitDurationInOpenState;
        @Min(value=1L)
        @Max(value=100L)
        @Nullable
        private @Min(value=1L) @Max(value=100L) Integer failureRateThreshold;
        @Min(value=1L)
        @Nullable
        private @Min(value=1L) Integer ringBufferSizeInClosedState;
        @Min(value=1L)
        @Nullable
        private @Min(value=1L) Integer ringBufferSizeInHalfOpenState;
        @Nullable
        private Boolean automaticTransitionFromOpenToHalfOpenEnabled;
        @Min(value=1L)
        @Nullable
        private @Min(value=1L) Integer eventConsumerBufferSize;
        @Nullable
        private Boolean registerHealthIndicator;
        @Nullable
        private Class<Predicate<Throwable>> recordFailurePredicate;
        @Nullable
        private Class<? extends Throwable>[] recordExceptions;
        @Nullable
        private Class<? extends Throwable>[] ignoreExceptions;
        @Nullable
        private String baseConfig;

        @Nullable
        public Integer getFailureRateThreshold() {
            return this.failureRateThreshold;
        }

        public InstanceProperties setFailureRateThreshold(Integer failureRateThreshold) {
            this.failureRateThreshold = failureRateThreshold;
            return this;
        }

        @Nullable
        public Duration getWaitDurationInOpenState() {
            return this.waitDurationInOpenState;
        }

        public InstanceProperties setWaitDurationInOpenState(Duration waitDurationInOpenStateMillis) {
            this.waitDurationInOpenState = waitDurationInOpenStateMillis;
            return this;
        }

        @Nullable
        public Integer getRingBufferSizeInClosedState() {
            return this.ringBufferSizeInClosedState;
        }

        public InstanceProperties setRingBufferSizeInClosedState(Integer ringBufferSizeInClosedState) {
            this.ringBufferSizeInClosedState = ringBufferSizeInClosedState;
            return this;
        }

        @Nullable
        public Integer getRingBufferSizeInHalfOpenState() {
            return this.ringBufferSizeInHalfOpenState;
        }

        public InstanceProperties setRingBufferSizeInHalfOpenState(Integer ringBufferSizeInHalfOpenState) {
            this.ringBufferSizeInHalfOpenState = ringBufferSizeInHalfOpenState;
            return this;
        }

        public Boolean getAutomaticTransitionFromOpenToHalfOpenEnabled() {
            return this.automaticTransitionFromOpenToHalfOpenEnabled;
        }

        public InstanceProperties setAutomaticTransitionFromOpenToHalfOpenEnabled(Boolean automaticTransitionFromOpenToHalfOpenEnabled) {
            this.automaticTransitionFromOpenToHalfOpenEnabled = automaticTransitionFromOpenToHalfOpenEnabled;
            return this;
        }

        public Integer getEventConsumerBufferSize() {
            return this.eventConsumerBufferSize;
        }

        public InstanceProperties setEventConsumerBufferSize(Integer eventConsumerBufferSize) {
            this.eventConsumerBufferSize = eventConsumerBufferSize;
            return this;
        }

        public Boolean getRegisterHealthIndicator() {
            return this.registerHealthIndicator;
        }

        public InstanceProperties setRegisterHealthIndicator(Boolean registerHealthIndicator) {
            this.registerHealthIndicator = registerHealthIndicator;
            return this;
        }

        @Nullable
        public Class<Predicate<Throwable>> getRecordFailurePredicate() {
            return this.recordFailurePredicate;
        }

        public InstanceProperties setRecordFailurePredicate(Class<Predicate<Throwable>> recordFailurePredicate) {
            this.recordFailurePredicate = recordFailurePredicate;
            return this;
        }

        @Nullable
        public Class<? extends Throwable>[] getRecordExceptions() {
            return this.recordExceptions;
        }

        public InstanceProperties setRecordExceptions(Class<? extends Throwable>[] recordExceptions) {
            this.recordExceptions = recordExceptions;
            return this;
        }

        @Nullable
        public Class<? extends Throwable>[] getIgnoreExceptions() {
            return this.ignoreExceptions;
        }

        public InstanceProperties setIgnoreExceptions(Class<? extends Throwable>[] ignoreExceptions) {
            this.ignoreExceptions = ignoreExceptions;
            return this;
        }

        @Nullable
        public String getBaseConfig() {
            return this.baseConfig;
        }

        public InstanceProperties setBaseConfig(String baseConfig) {
            this.baseConfig = baseConfig;
            return this;
        }
    }
}

