/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.feign;

import io.github.resilience4j.core.functions.CheckedFunction;
import java.lang.reflect.Method;
import java.util.function.Predicate;

interface FallbackHandler<T> {
    public CheckedFunction<Object[], Object> decorate(CheckedFunction<Object[], Object> var1, Method var2, Predicate<Exception> var3);

    default public void validateFallback(T fallback, Method method) {
        if (fallback.getClass().isAssignableFrom(method.getDeclaringClass())) {
            throw new IllegalArgumentException("Cannot use the fallback [" + fallback.getClass() + "] for [" + method.getDeclaringClass() + "]!");
        }
    }

    default public Method getFallbackMethod(T fallbackInstance, Method method) {
        Method fallbackMethod;
        try {
            fallbackMethod = fallbackInstance.getClass().getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException("Cannot use the fallback [" + fallbackInstance.getClass() + "] for [" + method.getDeclaringClass() + "]", e);
        }
        return fallbackMethod;
    }
}

