/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.feign;

import feign.InvocationHandlerFactory;
import feign.Target;
import feign.Util;
import io.github.resilience4j.feign.FeignDecorator;
import io.vavr.CheckedFunction1;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

class DecoratorInvocationHandler
implements InvocationHandler {
    private final Target<?> target;
    private final Map<Method, CheckedFunction1<Object[], Object>> decoratedDispatch;

    public DecoratorInvocationHandler(Target<?> target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch, FeignDecorator invocationDecorator) {
        this.target = (Target)Util.checkNotNull(target, (String)"target", (Object[])new Object[0]);
        Util.checkNotNull(dispatch, (String)"dispatch", (Object[])new Object[0]);
        this.decoratedDispatch = this.decorateMethodHandlers(dispatch, invocationDecorator, target);
    }

    private Map<Method, CheckedFunction1<Object[], Object>> decorateMethodHandlers(Map<Method, InvocationHandlerFactory.MethodHandler> dispatch, FeignDecorator invocationDecorator, Target<?> target) {
        HashMap<Method, CheckedFunction1<Object[], Object>> map = new HashMap<Method, CheckedFunction1<Object[], Object>>();
        for (Map.Entry<Method, InvocationHandlerFactory.MethodHandler> entry : dispatch.entrySet()) {
            Method method = entry.getKey();
            InvocationHandlerFactory.MethodHandler methodHandler = entry.getValue();
            map.put(method, invocationDecorator.decorate((CheckedFunction1<Object[], Object>)((CheckedFunction1 & Serializable)arg_0 -> ((InvocationHandlerFactory.MethodHandler)methodHandler).invoke(arg_0)), method, methodHandler, target));
        }
        return map;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        switch (method.getName()) {
            case "equals": {
                return this.equals(args.length > 0 ? args[0] : null);
            }
            case "hashCode": {
                return this.hashCode();
            }
            case "toString": {
                return this.toString();
            }
        }
        return this.decoratedDispatch.get(method).apply((Object)args);
    }

    public boolean equals(Object obj) {
        Object compareTo = obj;
        if (compareTo == null) {
            return false;
        }
        if (Proxy.isProxyClass(compareTo.getClass())) {
            compareTo = Proxy.getInvocationHandler(compareTo);
        }
        if (compareTo instanceof DecoratorInvocationHandler) {
            DecoratorInvocationHandler other = (DecoratorInvocationHandler)compareTo;
            return this.target.equals(other.target);
        }
        return false;
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public String toString() {
        return this.target.toString();
    }
}

