/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead;

import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.bulkhead.event.BulkheadEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallFinishedEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallPermittedEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallRejectedEvent;
import io.github.resilience4j.bulkhead.internal.SemaphoreBulkhead;
import io.github.resilience4j.bulkhead.utils.BulkheadUtils;
import io.github.resilience4j.core.EventConsumer;
import io.vavr.CheckedConsumer;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedRunnable;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Bulkhead {
    public void changeConfig(BulkheadConfig var1);

    public boolean isCallPermitted();

    public void onComplete();

    public String getName();

    public BulkheadConfig getBulkheadConfig();

    public Metrics getMetrics();

    public EventPublisher getEventPublisher();

    default public <T> T executeSupplier(Supplier<T> supplier) {
        return Bulkhead.decorateSupplier(this, supplier).get();
    }

    default public <T> T executeCallable(Callable<T> callable) throws Exception {
        return Bulkhead.decorateCallable(this, callable).call();
    }

    default public void executeRunnable(Runnable runnable) {
        Bulkhead.decorateRunnable(this, runnable).run();
    }

    default public <T> T executeCheckedSupplier(CheckedFunction0<T> checkedSupplier) throws Throwable {
        return (T)Bulkhead.decorateCheckedSupplier(this, checkedSupplier).apply();
    }

    default public <T> CompletionStage<T> executeCompletionStage(Supplier<CompletionStage<T>> supplier) {
        return Bulkhead.decorateCompletionStage(this, supplier).get();
    }

    public static <T> CheckedFunction0<T> decorateCheckedSupplier(Bulkhead bulkhead, CheckedFunction0<T> supplier) {
        return (CheckedFunction0 & Serializable)() -> {
            BulkheadUtils.isCallPermitted(bulkhead);
            try {
                Object object = supplier.apply();
                return object;
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static <T> Supplier<CompletionStage<T>> decorateCompletionStage(Bulkhead bulkhead, Supplier<CompletionStage<T>> supplier) {
        return () -> {
            CompletableFuture promise = new CompletableFuture();
            if (!bulkhead.isCallPermitted()) {
                promise.completeExceptionally(new BulkheadFullException(String.format("Bulkhead '%s' is open", bulkhead.getName())));
            } else {
                try {
                    ((CompletionStage)supplier.get()).whenComplete((result, throwable) -> {
                        bulkhead.onComplete();
                        if (throwable != null) {
                            promise.completeExceptionally((Throwable)throwable);
                        } else {
                            promise.complete(result);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    bulkhead.onComplete();
                    promise.completeExceptionally(throwable2);
                }
            }
            return promise;
        };
    }

    public static CheckedRunnable decorateCheckedRunnable(Bulkhead bulkhead, CheckedRunnable runnable) {
        return () -> {
            BulkheadUtils.isCallPermitted(bulkhead);
            try {
                runnable.run();
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static <T> Callable<T> decorateCallable(Bulkhead bulkhead, Callable<T> callable) {
        return () -> {
            BulkheadUtils.isCallPermitted(bulkhead);
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static <T> Supplier<T> decorateSupplier(Bulkhead bulkhead, Supplier<T> supplier) {
        return () -> {
            BulkheadUtils.isCallPermitted(bulkhead);
            try {
                Object t = supplier.get();
                return t;
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static <T> Consumer<T> decorateConsumer(Bulkhead bulkhead, Consumer<T> consumer) {
        return t -> {
            BulkheadUtils.isCallPermitted(bulkhead);
            try {
                consumer.accept(t);
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static <T> CheckedConsumer<T> decorateCheckedConsumer(Bulkhead bulkhead, CheckedConsumer<T> consumer) {
        return t -> {
            BulkheadUtils.isCallPermitted(bulkhead);
            try {
                consumer.accept(t);
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static Runnable decorateRunnable(Bulkhead bulkhead, Runnable runnable) {
        return () -> {
            BulkheadUtils.isCallPermitted(bulkhead);
            try {
                runnable.run();
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static <T, R> Function<T, R> decorateFunction(Bulkhead bulkhead, Function<T, R> function) {
        return t -> {
            BulkheadUtils.isCallPermitted(bulkhead);
            try {
                Object r = function.apply(t);
                return r;
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(Bulkhead bulkhead, CheckedFunction1<T, R> function) {
        return (CheckedFunction1 & Serializable)t -> {
            BulkheadUtils.isCallPermitted(bulkhead);
            try {
                Object object = function.apply(t);
                return object;
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static Bulkhead ofDefaults(String name) {
        return new SemaphoreBulkhead(name);
    }

    public static Bulkhead of(String name, BulkheadConfig config) {
        return new SemaphoreBulkhead(name, config);
    }

    public static Bulkhead of(String name, Supplier<BulkheadConfig> bulkheadConfigSupplier) {
        return new SemaphoreBulkhead(name, bulkheadConfigSupplier);
    }

    public static interface EventPublisher
    extends io.github.resilience4j.core.EventPublisher<BulkheadEvent> {
        public EventPublisher onCallRejected(EventConsumer<BulkheadOnCallRejectedEvent> var1);

        public EventPublisher onCallPermitted(EventConsumer<BulkheadOnCallPermittedEvent> var1);

        public EventPublisher onCallFinished(EventConsumer<BulkheadOnCallFinishedEvent> var1);
    }

    public static interface Metrics {
        public int getAvailableConcurrentCalls();

        public int getMaxAllowedConcurrentCalls();
    }
}

