/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.internal;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.vavr.collection.Array;
import io.vavr.collection.Seq;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public final class InMemoryBulkheadRegistry
implements BulkheadRegistry {
    private final BulkheadConfig defaultBulkheadConfig;
    private final ConcurrentMap<String, Bulkhead> bulkheads;

    public InMemoryBulkheadRegistry(BulkheadConfig bulkheadConfig) {
        this.defaultBulkheadConfig = bulkheadConfig;
        this.bulkheads = new ConcurrentHashMap<String, Bulkhead>();
    }

    @Override
    public Seq<Bulkhead> getAllBulkheads() {
        return Array.ofAll(this.bulkheads.values());
    }

    @Override
    public Bulkhead bulkhead(String name) {
        return this.bulkhead(name, this.defaultBulkheadConfig);
    }

    @Override
    public Bulkhead bulkhead(String name, BulkheadConfig bulkheadConfig) {
        return this.bulkheads.computeIfAbsent(Objects.requireNonNull(name, "Name must not be null"), k -> Bulkhead.of(name, bulkheadConfig));
    }

    @Override
    public Bulkhead bulkhead(String name, Supplier<BulkheadConfig> bulkheadConfigSupplier) {
        return this.bulkheads.computeIfAbsent(Objects.requireNonNull(name, "Name must not be null"), k -> Bulkhead.of(name, (BulkheadConfig)bulkheadConfigSupplier.get()));
    }

    @Override
    public BulkheadConfig getDefaultBulkheadConfig() {
        return this.defaultBulkheadConfig;
    }
}

