/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead;

public class BulkheadConfig {
    public static final int DEFAULT_MAX_CONCURRENT_CALLS = 25;
    public static final long DEFAULT_MAX_WAIT_TIME = 0L;
    private int maxConcurrentCalls = 25;
    private long maxWaitTime = 0L;

    private BulkheadConfig() {
    }

    public int getMaxConcurrentCalls() {
        return this.maxConcurrentCalls;
    }

    public long getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public static Builder custom() {
        return new Builder();
    }

    public static BulkheadConfig ofDefaults() {
        return new Builder().build();
    }

    public static class Builder {
        private BulkheadConfig config = new BulkheadConfig();

        public Builder maxConcurrentCalls(int maxConcurrentCalls) {
            if (maxConcurrentCalls < 1) {
                throw new IllegalArgumentException("maxConcurrentCalls must be a positive integer value >= 1");
            }
            this.config.maxConcurrentCalls = maxConcurrentCalls;
            return this;
        }

        public Builder maxWaitTime(long maxWaitTime) {
            if (maxWaitTime < 0L) {
                throw new IllegalArgumentException("maxWaitTime must be a positive integer value >= 0");
            }
            this.config.maxWaitTime = maxWaitTime;
            return this;
        }

        public BulkheadConfig build() {
            return this.config;
        }
    }
}

