/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.decorators;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.cache.Cache;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.retry.Retry;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedRunnable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Decorators {
    public static <T> DecorateSupplier<T> ofSupplier(Supplier<T> supplier) {
        return new DecorateSupplier(supplier);
    }

    public static <T, R> DecorateFunction<T, R> ofFunction(Function<T, R> function) {
        return new DecorateFunction(function);
    }

    public static DecorateRunnable ofRunnable(Runnable runnable) {
        return new DecorateRunnable(runnable);
    }

    public static <T> DecorateCheckedSupplier<T> ofCheckedSupplier(CheckedFunction0<T> supplier) {
        return new DecorateCheckedSupplier(supplier);
    }

    public static <T, R> DecorateCheckedFunction<T, R> ofCheckedFunction(CheckedFunction1<T, R> function) {
        return new DecorateCheckedFunction(function);
    }

    public static DecorateCheckedRunnable ofCheckedRunnable(CheckedRunnable supplier) {
        return new DecorateCheckedRunnable(supplier);
    }

    public static <T> DecorateCompletionStage<T> ofCompletionStage(Supplier<CompletionStage<T>> stageSupplier) {
        return new DecorateCompletionStage<T>(stageSupplier);
    }

    public static <T> DecorateConsumer<T> ofConsumer(Consumer<T> consumer) {
        return new DecorateConsumer(consumer);
    }

    public static class DecorateConsumer<T> {
        private Consumer<T> consumer;

        private DecorateConsumer(Consumer<T> consumer) {
            this.consumer = consumer;
        }

        public DecorateConsumer<T> withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.consumer = CircuitBreaker.decorateConsumer((CircuitBreaker)circuitBreaker, this.consumer);
            return this;
        }

        public DecorateConsumer<T> withRateLimiter(RateLimiter rateLimiter) {
            return this.withRateLimiter(rateLimiter, 1);
        }

        public DecorateConsumer<T> withRateLimiter(RateLimiter rateLimiter, int permits) {
            this.consumer = RateLimiter.decorateConsumer((RateLimiter)rateLimiter, (int)permits, this.consumer);
            return this;
        }

        public DecorateConsumer<T> withRateLimiter(RateLimiter rateLimiter, Function<T, Integer> permitsCalculator) {
            this.consumer = RateLimiter.decorateConsumer((RateLimiter)rateLimiter, permitsCalculator, this.consumer);
            return this;
        }

        public DecorateConsumer<T> withBulkhead(Bulkhead bulkhead) {
            this.consumer = Bulkhead.decorateConsumer((Bulkhead)bulkhead, this.consumer);
            return this;
        }

        public Consumer<T> decorate() {
            return this.consumer;
        }

        public void accept(T obj) {
            this.consumer.accept(obj);
        }
    }

    public static class DecorateCompletionStage<T> {
        private Supplier<CompletionStage<T>> stageSupplier;

        public DecorateCompletionStage(Supplier<CompletionStage<T>> stageSupplier) {
            this.stageSupplier = stageSupplier;
        }

        public DecorateCompletionStage<T> withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.stageSupplier = CircuitBreaker.decorateCompletionStage((CircuitBreaker)circuitBreaker, this.stageSupplier);
            return this;
        }

        public DecorateCompletionStage<T> withRetry(Retry retryContext, ScheduledExecutorService scheduler) {
            this.stageSupplier = Retry.decorateCompletionStage((Retry)retryContext, (ScheduledExecutorService)scheduler, this.stageSupplier);
            return this;
        }

        public DecorateCompletionStage<T> withBulkhead(Bulkhead bulkhead) {
            this.stageSupplier = Bulkhead.decorateCompletionStage((Bulkhead)bulkhead, this.stageSupplier);
            return this;
        }

        public DecorateCompletionStage<T> withRateLimiter(RateLimiter rateLimiter) {
            return this.withRateLimiter(rateLimiter, 1);
        }

        public DecorateCompletionStage<T> withRateLimiter(RateLimiter rateLimiter, int permits) {
            this.stageSupplier = RateLimiter.decorateCompletionStage((RateLimiter)rateLimiter, (int)permits, this.stageSupplier);
            return this;
        }

        public Supplier<CompletionStage<T>> decorate() {
            return this.stageSupplier;
        }

        public CompletionStage<T> get() {
            return this.stageSupplier.get();
        }
    }

    public static class DecorateCheckedRunnable {
        private CheckedRunnable runnable;

        private DecorateCheckedRunnable(CheckedRunnable runnable) {
            this.runnable = runnable;
        }

        public DecorateCheckedRunnable withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.runnable = CircuitBreaker.decorateCheckedRunnable((CircuitBreaker)circuitBreaker, (CheckedRunnable)this.runnable);
            return this;
        }

        public DecorateCheckedRunnable withRetry(Retry retryContext) {
            this.runnable = Retry.decorateCheckedRunnable((Retry)retryContext, (CheckedRunnable)this.runnable);
            return this;
        }

        public DecorateCheckedRunnable withRateLimiter(RateLimiter rateLimiter) {
            this.runnable = RateLimiter.decorateCheckedRunnable((RateLimiter)rateLimiter, (CheckedRunnable)this.runnable);
            return this;
        }

        public DecorateCheckedRunnable withRateLimiter(RateLimiter rateLimiter, int permits) {
            this.runnable = RateLimiter.decorateCheckedRunnable((RateLimiter)rateLimiter, (int)permits, (CheckedRunnable)this.runnable);
            return this;
        }

        public DecorateCheckedRunnable withBulkhead(Bulkhead bulkhead) {
            this.runnable = Bulkhead.decorateCheckedRunnable((Bulkhead)bulkhead, (CheckedRunnable)this.runnable);
            return this;
        }

        public CheckedRunnable decorate() {
            return this.runnable;
        }

        public void run() throws Throwable {
            this.runnable.run();
        }
    }

    public static class DecorateCheckedFunction<T, R> {
        private CheckedFunction1<T, R> function;

        private DecorateCheckedFunction(CheckedFunction1<T, R> function) {
            this.function = function;
        }

        public DecorateCheckedFunction<T, R> withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.function = CircuitBreaker.decorateCheckedFunction((CircuitBreaker)circuitBreaker, this.function);
            return this;
        }

        public DecorateCheckedFunction<T, R> withRetry(Retry retryContext) {
            this.function = Retry.decorateCheckedFunction((Retry)retryContext, this.function);
            return this;
        }

        public DecorateCheckedFunction<T, R> withRateLimiter(RateLimiter rateLimiter) {
            return this.withRateLimiter(rateLimiter, 1);
        }

        public DecorateCheckedFunction<T, R> withRateLimiter(RateLimiter rateLimiter, int permits) {
            this.function = RateLimiter.decorateCheckedFunction((RateLimiter)rateLimiter, (int)permits, this.function);
            return this;
        }

        public DecorateCheckedFunction<T, R> withRateLimiter(RateLimiter rateLimiter, Function<T, Integer> permitsCalculator) {
            this.function = RateLimiter.decorateCheckedFunction((RateLimiter)rateLimiter, permitsCalculator, this.function);
            return this;
        }

        public DecorateCheckedFunction<T, R> withBulkhead(Bulkhead bulkhead) {
            this.function = Bulkhead.decorateCheckedFunction((Bulkhead)bulkhead, this.function);
            return this;
        }

        public CheckedFunction1<T, R> decorate() {
            return this.function;
        }

        public R apply(T t) throws Throwable {
            return (R)this.function.apply(t);
        }
    }

    public static class DecorateCheckedSupplier<T> {
        private CheckedFunction0<T> supplier;

        private DecorateCheckedSupplier(CheckedFunction0<T> supplier) {
            this.supplier = supplier;
        }

        public DecorateCheckedSupplier<T> withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.supplier = CircuitBreaker.decorateCheckedSupplier((CircuitBreaker)circuitBreaker, this.supplier);
            return this;
        }

        public DecorateCheckedSupplier<T> withRetry(Retry retryContext) {
            this.supplier = Retry.decorateCheckedSupplier((Retry)retryContext, this.supplier);
            return this;
        }

        public DecorateCheckedSupplier<T> withRateLimiter(RateLimiter rateLimiter) {
            return this.withRateLimiter(rateLimiter, 1);
        }

        public DecorateCheckedSupplier<T> withRateLimiter(RateLimiter rateLimiter, int permits) {
            this.supplier = RateLimiter.decorateCheckedSupplier((RateLimiter)rateLimiter, (int)permits, this.supplier);
            return this;
        }

        public <K> DecorateCheckedFunction<K, T> withCache(Cache<K, T> cache) {
            return Decorators.ofCheckedFunction(Cache.decorateCheckedSupplier(cache, this.supplier));
        }

        public DecorateCheckedSupplier<T> withBulkhead(Bulkhead bulkhead) {
            this.supplier = Bulkhead.decorateCheckedSupplier((Bulkhead)bulkhead, this.supplier);
            return this;
        }

        public CheckedFunction0<T> decorate() {
            return this.supplier;
        }

        public T get() throws Throwable {
            return (T)this.supplier.apply();
        }
    }

    public static class DecorateRunnable {
        private Runnable runnable;

        private DecorateRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        public DecorateRunnable withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.runnable = CircuitBreaker.decorateRunnable((CircuitBreaker)circuitBreaker, (Runnable)this.runnable);
            return this;
        }

        public DecorateRunnable withRetry(Retry retryContext) {
            this.runnable = Retry.decorateRunnable((Retry)retryContext, (Runnable)this.runnable);
            return this;
        }

        public DecorateRunnable withRateLimiter(RateLimiter rateLimiter) {
            return this.withRateLimiter(rateLimiter, 1);
        }

        public DecorateRunnable withRateLimiter(RateLimiter rateLimiter, int permits) {
            this.runnable = RateLimiter.decorateRunnable((RateLimiter)rateLimiter, (int)permits, (Runnable)this.runnable);
            return this;
        }

        public DecorateRunnable withBulkhead(Bulkhead bulkhead) {
            this.runnable = Bulkhead.decorateRunnable((Bulkhead)bulkhead, (Runnable)this.runnable);
            return this;
        }

        public Runnable decorate() {
            return this.runnable;
        }

        public void run() {
            this.runnable.run();
        }
    }

    public static class DecorateFunction<T, R> {
        private Function<T, R> function;

        private DecorateFunction(Function<T, R> function) {
            this.function = function;
        }

        public DecorateFunction<T, R> withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.function = CircuitBreaker.decorateFunction((CircuitBreaker)circuitBreaker, this.function);
            return this;
        }

        public DecorateFunction<T, R> withRetry(Retry retryContext) {
            this.function = Retry.decorateFunction((Retry)retryContext, this.function);
            return this;
        }

        public DecorateFunction<T, R> withRateLimiter(RateLimiter rateLimiter) {
            return this.withRateLimiter(rateLimiter, 1);
        }

        public DecorateFunction<T, R> withRateLimiter(RateLimiter rateLimiter, int permits) {
            this.function = RateLimiter.decorateFunction((RateLimiter)rateLimiter, (int)permits, this.function);
            return this;
        }

        public DecorateFunction<T, R> withRateLimiter(RateLimiter rateLimiter, Function<T, Integer> permitsCalculator) {
            this.function = RateLimiter.decorateFunction((RateLimiter)rateLimiter, permitsCalculator, this.function);
            return this;
        }

        public DecorateFunction<T, R> withBulkhead(Bulkhead bulkhead) {
            this.function = Bulkhead.decorateFunction((Bulkhead)bulkhead, this.function);
            return this;
        }

        public Function<T, R> decorate() {
            return this.function;
        }

        public R apply(T t) {
            return this.function.apply(t);
        }
    }

    public static class DecorateSupplier<T> {
        private Supplier<T> supplier;

        private DecorateSupplier(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        public DecorateSupplier<T> withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.supplier = CircuitBreaker.decorateSupplier((CircuitBreaker)circuitBreaker, this.supplier);
            return this;
        }

        public DecorateSupplier<T> withRetry(Retry retryContext) {
            this.supplier = Retry.decorateSupplier((Retry)retryContext, this.supplier);
            return this;
        }

        public <K> DecorateFunction<K, T> withCache(Cache<K, T> cache) {
            return Decorators.ofFunction(Cache.decorateSupplier(cache, this.supplier));
        }

        public DecorateSupplier<T> withRateLimiter(RateLimiter rateLimiter) {
            return this.withRateLimiter(rateLimiter, 1);
        }

        public DecorateSupplier<T> withRateLimiter(RateLimiter rateLimiter, int permits) {
            this.supplier = RateLimiter.decorateSupplier((RateLimiter)rateLimiter, (int)permits, this.supplier);
            return this;
        }

        public DecorateSupplier<T> withBulkhead(Bulkhead bulkhead) {
            this.supplier = Bulkhead.decorateSupplier((Bulkhead)bulkhead, this.supplier);
            return this;
        }

        public Supplier<T> decorate() {
            return this.supplier;
        }

        public T get() {
            return this.supplier.get();
        }
    }
}

