/*
 * Decompiled with CFR 0.152.
 */
package io.github.pixee.security;

import io.github.pixee.security.CommandLine;
import io.github.pixee.security.J8ApiBridge;
import io.github.pixee.security.SystemCommandRestrictions;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class SystemCommand {
    private static final List<String> SHELL_FILE_NAMES = J8ApiBridge.listOf("bash", "sh", "zsh", "csh", "tcsh");
    private static final List<String> BANNED_EXECUTABLES = J8ApiBridge.listOf("nc", "curl", "wget", "dpkg", "rpm");
    private static final List<String> SENSITIVE_FILE_NAMES = J8ApiBridge.listOf("/etc/passwd", "/etc/shadow", "/etc/group", "/etc/gshadow", "/etc/sysconfig/network", "/etc/network/interfaces", "/etc/resolv.conf", "/etc/sudoers", "/etc/hosts");

    private SystemCommand() {
    }

    public static Set<SystemCommandRestrictions> defaultRestrictions() {
        return J8ApiBridge.setOf(SystemCommandRestrictions.PREVENT_COMMAND_CHAINING, SystemCommandRestrictions.PREVENT_ARGUMENTS_TARGETING_SENSITIVE_FILES);
    }

    public static Process runCommand(Runtime runtime, String command, Set<SystemCommandRestrictions> restrictions) throws IOException {
        SystemCommand.runChecks(command, restrictions);
        return runtime.exec(command);
    }

    public static Process runCommand(Runtime runtime, String command) throws IOException {
        return SystemCommand.runCommand(runtime, command, SystemCommand.defaultRestrictions());
    }

    public static Process runCommand(Runtime runtime, String[] command, Set<SystemCommandRestrictions> restrictions) throws IOException {
        SystemCommand.runChecks(command, restrictions);
        return runtime.exec(command);
    }

    public static Process runCommand(Runtime runtime, String[] command) throws IOException {
        return SystemCommand.runCommand(runtime, command, SystemCommand.defaultRestrictions());
    }

    public static Process runCommand(Runtime runtime, String[] command, String[] envp, Set<SystemCommandRestrictions> restrictions) throws IOException {
        SystemCommand.runChecks(command, restrictions);
        return runtime.exec(command, envp);
    }

    public static Process runCommand(Runtime runtime, String[] command, String[] envp) throws IOException {
        return SystemCommand.runCommand(runtime, command, envp, SystemCommand.defaultRestrictions());
    }

    public static Process runCommand(Runtime runtime, String[] command, String[] envp, File dir, Set<SystemCommandRestrictions> restrictions) throws IOException {
        SystemCommand.runChecks(command, restrictions);
        return runtime.exec(command, envp, dir);
    }

    public static Process runCommand(Runtime runtime, String command, String[] envp, Set<SystemCommandRestrictions> restrictions) throws IOException {
        SystemCommand.runChecks(command, restrictions);
        return runtime.exec(command, envp);
    }

    public static Process runCommand(Runtime runtime, String command, String[] envp) throws IOException {
        return SystemCommand.runCommand(runtime, command, envp, SystemCommand.defaultRestrictions());
    }

    public static Process runCommand(Runtime runtime, String command, String[] envp, File dir, Set<SystemCommandRestrictions> restrictions) throws IOException {
        SystemCommand.runChecks(command, restrictions);
        return runtime.exec(command, envp, dir);
    }

    public static Process runCommand(Runtime runtime, String command, String[] envp, File dir) throws IOException {
        return SystemCommand.runCommand(runtime, command, envp, dir, SystemCommand.defaultRestrictions());
    }

    public static Process runCommand(Runtime runtime, String[] command, String[] envp, File dir) throws IOException {
        return SystemCommand.runCommand(runtime, command, envp, dir, SystemCommand.defaultRestrictions());
    }

    private static void runChecks(String command, Set<SystemCommandRestrictions> restrictions) {
        if (!command.trim().isEmpty()) {
            CommandLine parsedCommandLine = CommandLine.parse(command);
            SystemCommand.runChecks(parsedCommandLine, restrictions);
        }
    }

    private static void runChecks(String[] command, Set<SystemCommandRestrictions> restrictions) {
        CommandLine parsedCommandLine = new CommandLine(command[0]);
        for (int i = 1; i < command.length; ++i) {
            parsedCommandLine.addArgument(command[i]);
        }
        SystemCommand.runChecks(parsedCommandLine, restrictions);
    }

    private static void runChecks(CommandLine parsedCommandLine, Set<SystemCommandRestrictions> restrictions) {
        if (restrictions == null) {
            throw new IllegalArgumentException("restrictions must not be null");
        }
        if (restrictions.contains((Object)SystemCommandRestrictions.PREVENT_COMMAND_CHAINING) && SystemCommand.isShell(parsedCommandLine.getExecutable())) {
            SystemCommand.checkForMultipleCommands(parsedCommandLine.getArguments());
        }
        if (restrictions.contains((Object)SystemCommandRestrictions.PREVENT_COMMON_EXPLOIT_EXECUTABLES)) {
            SystemCommand.checkForBannedExecutable(parsedCommandLine);
        }
        if (restrictions.contains((Object)SystemCommandRestrictions.PREVENT_ARGUMENTS_TARGETING_SENSITIVE_FILES)) {
            SystemCommand.checkForSensitiveFileArguments(parsedCommandLine);
        }
    }

    private static void checkForBannedExecutable(CommandLine commandLine) {
        String executable = commandLine.getExecutable();
        try {
            File file = new File(executable).getCanonicalFile();
            String name = file.getName().trim();
            if (BANNED_EXECUTABLES.contains(name)) {
                throw new SecurityException("file inaccessible");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void checkForSensitiveFileArguments(CommandLine commandLine) {
        String[] arguments;
        for (String argument : arguments = commandLine.getArguments()) {
            try {
                File file = new File(argument).getCanonicalFile();
                String name = file.getAbsolutePath().trim();
                for (String sensitiveFileName : SENSITIVE_FILE_NAMES) {
                    if (!name.endsWith(sensitiveFileName)) continue;
                    throw new SecurityException("file inaccessible");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void checkForMultipleCommands(String[] commandTokens) {
        int indexOfCommand = SystemCommand.getCommandIndex(commandTokens);
        if (indexOfCommand != -1 && commandTokens.length > indexOfCommand) {
            int index;
            String innerCommand = commandTokens[indexOfCommand];
            String trimmedCommand = innerCommand.trim();
            if (trimmedCommand.startsWith("\"") && trimmedCommand.endsWith("\"")) {
                trimmedCommand = trimmedCommand.substring(1, trimmedCommand.length() - 1);
            }
            if ((index = SystemCommand.findCommandSeparator(trimmedCommand)) == -1) {
                throw new SecurityException("multiple commands not allowed");
            }
        }
    }

    private static int findCommandSeparator(String command) {
        LinkedList<CommandParsingContext> context = new LinkedList<CommandParsingContext>();
        int i = 0;
        context.push(CommandParsingContext.DEFAULT);
        block11: while (i < command.length()) {
            CommandParsingContext currentContext = (CommandParsingContext)((Object)context.peek());
            block0 : switch (currentContext) {
                case DOUBLE_QUOTE: {
                    i = SystemCommand.eatUntilNextDoubleQuote(command, i);
                    context.pop();
                    continue block11;
                }
                case SINGLE_QUOTE: {
                    i = SystemCommand.eatUntilNextSingleQuote(command, i);
                    context.pop();
                    continue block11;
                }
                case COMMENT: {
                    i = SystemCommand.eatUntilNextNewline(command, i);
                    context.pop();
                }
                case DEFAULT: {
                    char ch = command.charAt(i);
                    switch (ch) {
                        case '\"': {
                            context.push(CommandParsingContext.DOUBLE_QUOTE);
                            ++i;
                            break block0;
                        }
                        case '\'': {
                            context.push(CommandParsingContext.SINGLE_QUOTE);
                            ++i;
                            break block0;
                        }
                        case '&': 
                        case ';': 
                        case '|': {
                            return i;
                        }
                    }
                    ++i;
                }
            }
            return -1;
        }
        return -1;
    }

    private static int eatUntilNextDoubleQuote(String command, int offset) {
        return SystemCommand.eatUntilChar(command, offset, '\"');
    }

    private static int eatUntilNextSingleQuote(String command, int offset) {
        return SystemCommand.eatUntilChar(command, offset, '\"');
    }

    private static int eatUntilNextNewline(String command, int offset) {
        return SystemCommand.eatUntilChar(command, offset, '\n');
    }

    private static int eatUntilChar(String command, int offset, char ch) {
        for (int i = offset + 1; i < command.length(); ++i) {
            if (command.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    private static int getCommandIndex(String[] commandTokens) {
        for (int i = 0; i < commandTokens.length; ++i) {
            if (!"-c".equals(commandTokens[i])) continue;
            return i + 1;
        }
        return -1;
    }

    private static boolean isShell(String commandToken) {
        File commandFile = new File(commandToken);
        if (new File("/bin").equals(commandFile.getParentFile())) {
            return commandFile.getName().endsWith("sh");
        }
        return SHELL_FILE_NAMES.contains(commandFile.getName());
    }

    static enum CommandParsingContext {
        DEFAULT,
        SINGLE_QUOTE,
        DOUBLE_QUOTE,
        COMMENT;

    }
}

