/*
 * Decompiled with CFR 0.152.
 */
package io.github.pixee.security;

import io.github.pixee.security.HostValidator;
import io.github.pixee.security.J8ApiBridge;
import io.github.pixee.security.UrlProtocol;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.Set;

public final class Urls {
    public static Set<UrlProtocol> HTTP_PROTOCOLS = J8ApiBridge.setOf(UrlProtocol.HTTPS, UrlProtocol.HTTP);

    public static URL create(String url, Set<UrlProtocol> allowedProtocols, HostValidator validator) throws MalformedURLException {
        URL u = new URL(url);
        return Urls.create(u, allowedProtocols, validator);
    }

    public static URL create(String protocol, String host, int port, String file, Set<UrlProtocol> allowedProtocols, HostValidator hostValidator) throws MalformedURLException {
        URL u = new URL(protocol, host, port, file);
        return Urls.create(u, allowedProtocols, hostValidator);
    }

    public static URL create(String protocol, String host, int port, String file, URLStreamHandler handler, Set<UrlProtocol> allowedProtocols, HostValidator hostValidator) throws MalformedURLException {
        URL u = new URL(protocol, host, port, file, handler);
        return Urls.create(u, allowedProtocols, hostValidator);
    }

    public static URL create(URL context, String spec, Set<UrlProtocol> allowedProtocols, HostValidator hostValidator) throws MalformedURLException {
        URL u = new URL(context, spec);
        return Urls.create(u, allowedProtocols, hostValidator);
    }

    public static URL create(URL context, String spec, URLStreamHandler handler, Set<UrlProtocol> allowedProtocols, HostValidator hostValidator) throws MalformedURLException {
        URL u = new URL(context, spec, handler);
        return Urls.create(u, allowedProtocols, hostValidator);
    }

    public static URL create(String protocol, String host, String file, Set<UrlProtocol> allowedProtocols, HostValidator hostValidator) throws MalformedURLException {
        URL u = new URL(protocol, host, file);
        return Urls.create(u, allowedProtocols, hostValidator);
    }

    private static URL create(URL u, Set<UrlProtocol> allowedProtocols, HostValidator hostValidator) {
        Urls.checkProtocolAllowed(u.getProtocol(), allowedProtocols);
        Urls.checkHostsAllowed(u.getHost(), hostValidator);
        return u;
    }

    private static void checkHostsAllowed(String host, HostValidator hostValidator) {
        if (!hostValidator.isAllowed(host)) {
            throw new SecurityException("disallowed host: " + host);
        }
    }

    private static void checkProtocolAllowed(String parsedProtocol, Set<UrlProtocol> protocols) {
        if (protocols != null && !protocols.isEmpty() && !protocols.contains((Object)UrlProtocol.ANY)) {
            for (UrlProtocol allowedProtocol : protocols) {
                String key = allowedProtocol.getKey();
                if (!parsedProtocol.equalsIgnoreCase(key)) continue;
                return;
            }
            throw new SecurityException("disallowed protocol: " + parsedProtocol);
        }
    }
}

