/*
 * Decompiled with CFR 0.152.
 */
package io.github.pixee.security;

import java.io.IOException;
import java.io.Reader;
import java.util.Objects;

public final class BoundedLineReader {
    private BoundedLineReader() {
    }

    private static String readLine(ReaderWrapper in, int max) throws IOException {
        if (max <= 0) {
            throw new IllegalArgumentException("must read a positive number of bytes from the stream");
        }
        StringBuilder sb = new StringBuilder();
        int count = 0;
        while (true) {
            int c;
            if ((c = in.read()) == -1) {
                if (sb.length() != 0) break;
                return null;
            }
            if (c == 10 || c == 13) break;
            if (++count > max) {
                throw new SecurityException("read more than maximum characters allowed (" + max + ")");
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String readLine(Reader reader, int max) throws IOException {
        return BoundedLineReader.readLine(new BufferedReaderWrapper(reader), max);
    }

    private static class BufferedReaderWrapper
    implements ReaderWrapper {
        private final Reader bufferedReader;

        private BufferedReaderWrapper(Reader bufferedReader) {
            this.bufferedReader = Objects.requireNonNull(bufferedReader);
        }

        @Override
        public int read() throws IOException {
            return this.bufferedReader.read();
        }
    }

    private static interface ReaderWrapper {
        public int read() throws IOException;
    }
}

