/*
 * Decompiled with CFR 0.152.
 */
package nl.adaptivity.xmlutil.serialization.impl;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import nl.adaptivity.xmlutil.XmlUtilInternal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlUtilInternal
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\n\u001a\u00020\u000b*\u00020\t2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0082\u0002J%\u0010\u000e\u001a\u00020\u000f*\u00020\t2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u000bH\u0082\u0002J\u0016\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003J\u0016\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003J\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003J\u0016\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0013\u0010\u001a\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lnl/adaptivity/xmlutil/serialization/impl/OrderMatrix;", "", "size", "", "<init>", "(I)V", "getSize", "()I", "data", "", "get", "", "x", "y", "set", "", "value", "isOrderedBefore", "self", "ref", "isOrderedAfter", "setOrderedBefore", "setOrderedAfter", "setOrderedAfterImpl", "toString", "", "equals", "other", "hashCode", "serialization"})
public final class OrderMatrix {
    private final int size;
    @NotNull
    private final boolean[] data;

    public OrderMatrix(int size) {
        this.size = size;
        this.data = new boolean[this.size * this.size];
    }

    public final int getSize() {
        return this.size;
    }

    private final boolean get(boolean[] $this$get, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        return $this$get[x + y * this.size];
    }

    private final void set(boolean[] $this$set, int x, int y, boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$set, (String)"<this>");
        $this$set[x + y * this.size] = value;
    }

    public final boolean isOrderedBefore(int self, int ref) {
        if (!(0 <= self ? self < this.size : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(0 <= ref ? ref < this.size : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.get(this.data, ref, self);
    }

    public final boolean isOrderedAfter(int self, int ref) {
        if (!(0 <= self ? self < this.size : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(0 <= ref ? ref < this.size : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.get(this.data, self, ref);
    }

    public final void setOrderedBefore(int self, int ref) {
        if (!(0 <= self ? self < this.size : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(0 <= ref ? ref < this.size : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.setOrderedAfterImpl(ref, self);
    }

    public final boolean setOrderedAfter(int self, int ref) {
        if (!(0 <= self ? self < this.size : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(0 <= ref ? ref < this.size : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.setOrderedAfterImpl(self, ref);
    }

    private final boolean setOrderedAfterImpl(int self, int ref) {
        boolean bl;
        if (this.get(this.data, self, ref)) {
            bl = false;
        } else {
            int i;
            this.set(this.data, self, ref, true);
            int n = this.size;
            for (i = 0; i < n; ++i) {
                if (!this.get(this.data, ref, i)) continue;
                this.setOrderedAfterImpl(self, i);
            }
            n = this.size;
            for (i = 0; i < n; ++i) {
                if (!this.get(this.data, i, self)) continue;
                this.setOrderedAfterImpl(i, ref);
            }
            bl = true;
        }
        return bl;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int lblWidth = String.valueOf(this.size - 1).length();
        String absent = StringsKt.padEnd((String)"", (int)(2 * lblWidth + 1), (char)'.');
        CollectionsKt.joinTo$default((Iterable)((Iterable)RangesKt.until((int)0, (int)this.size)), (Appendable)$this$toString_u24lambda_u240, (CharSequence)" ", (CharSequence)StringsKt.padStart$default((String)"", (int)(lblWidth + 1), (char)'\u0000', (int)2, null), null, (int)0, null, arg_0 -> OrderMatrix.toString$lambda$0$0(lblWidth, arg_0), (int)56, null);
        int n = this.size;
        for (int y = 0; y < n; ++y) {
            String ys = StringsKt.padEnd((String)String.valueOf(y), (int)lblWidth, (char)'_');
            $this$toString_u24lambda_u240.append('\n');
            String lbl = String.valueOf(y);
            int i = 0;
            int n2 = lblWidth - lbl.length();
            if (i <= n2) {
                while (true) {
                    $this$toString_u24lambda_u240.append(' ');
                    if (i == n2) break;
                    ++i;
                }
            }
            $this$toString_u24lambda_u240.append(lbl).append(' ');
            CollectionsKt.joinTo$default((Iterable)((Iterable)RangesKt.until((int)0, (int)this.size)), (Appendable)$this$toString_u24lambda_u240, (CharSequence)" ", null, null, (int)0, null, arg_0 -> OrderMatrix.toString$lambda$0$1(this, y, lblWidth, ys, absent, arg_0), (int)60, null);
        }
        return stringBuilder.toString();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        OrderMatrix cfr_ignored_0 = (OrderMatrix)other;
        if (this.size != ((OrderMatrix)other).size) {
            return false;
        }
        return Arrays.equals(this.data, ((OrderMatrix)other).data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    private static final CharSequence toString$lambda$0$0(int $lblWidth, int it) {
        return StringsKt.padEnd$default((String)StringsKt.padStart$default((String)String.valueOf(it), (int)($lblWidth + $lblWidth / 2 + 1), (char)'\u0000', (int)2, null), (int)($lblWidth * 2 + 1), (char)'\u0000', (int)2, null);
    }

    private static final CharSequence toString$lambda$0$1(OrderMatrix this$0, int $y, int $lblWidth, String $ys, String $absent, int x) {
        return this$0.get(this$0.data, x, $y) ? (CharSequence)(StringsKt.padStart((String)String.valueOf(x), (int)$lblWidth, (char)' ') + '>' + $ys) : (CharSequence)$absent;
    }
}

