/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.iterator;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.iterator.ASeekingIterator;
import org.iq80.leveldb.iterator.InternalIterator;
import org.iq80.leveldb.util.Slice;

public final class MemTableIterator
extends ASeekingIterator<InternalKey, Slice>
implements InternalIterator {
    private PeekingIterator<Map.Entry<InternalKey, Slice>> iterator;
    private Map.Entry<InternalKey, Slice> entry;
    private final ConcurrentNavigableMap<InternalKey, Slice> table;

    public MemTableIterator(ConcurrentNavigableMap<InternalKey, Slice> table) {
        this.table = table;
    }

    @Override
    protected boolean internalSeekToFirst() {
        this.iterator = Iterators.peekingIterator(this.table.entrySet().iterator());
        this.entry = this.iterator.hasNext() ? (Map.Entry)this.iterator.next() : null;
        return this.entry != null;
    }

    @Override
    protected boolean internalSeekToLast() {
        this.iterator = Iterators.peekingIterator(this.table.descendingMap().entrySet().iterator());
        this.entry = this.iterator.hasNext() ? (Map.Entry)this.iterator.next() : null;
        return this.entry != null;
    }

    @Override
    protected boolean internalSeek(InternalKey targetKey) {
        this.iterator = Iterators.peekingIterator(this.table.tailMap((Object)targetKey).entrySet().iterator());
        this.entry = this.iterator.hasNext() ? (Map.Entry)this.iterator.next() : null;
        return this.entry != null;
    }

    @Override
    protected boolean internalNext(boolean switchDirection) {
        if (switchDirection) {
            this.iterator = Iterators.peekingIterator(this.table.tailMap((Object)this.entry.getKey()).entrySet().iterator());
            if (this.iterator.hasNext()) {
                this.iterator.next();
            }
        }
        this.entry = this.iterator.hasNext() ? (Map.Entry)this.iterator.next() : null;
        return this.entry != null;
    }

    @Override
    protected boolean internalPrev(boolean switchDirection) {
        if (switchDirection) {
            this.iterator = Iterators.peekingIterator(this.table.descendingMap().tailMap(this.entry.getKey()).entrySet().iterator());
            if (this.iterator.hasNext()) {
                this.iterator.next();
            }
        }
        this.entry = this.iterator.hasNext() ? (Map.Entry)this.iterator.next() : null;
        return this.entry != null;
    }

    @Override
    protected InternalKey internalKey() {
        return this.entry.getKey();
    }

    @Override
    protected Slice internalValue() {
        return this.entry.getValue();
    }

    @Override
    public void internalClose() {
        this.iterator = null;
    }
}

