/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.iterator;

import java.io.IOException;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.iterator.InternalIterator;
import org.iq80.leveldb.iterator.SliceIterator;
import org.iq80.leveldb.util.Slice;

public class InternalTableIterator
implements InternalIterator {
    private final SliceIterator tableIterator;
    private InternalKey key;

    public InternalTableIterator(SliceIterator tableIterator) {
        this.tableIterator = tableIterator;
    }

    @Override
    public boolean valid() {
        return this.tableIterator.valid();
    }

    @Override
    public boolean seekToFirst() {
        this.key = null;
        return this.tableIterator.seekToFirst();
    }

    @Override
    public boolean seek(InternalKey targetKey) {
        this.key = null;
        return this.tableIterator.seek(targetKey.encode());
    }

    @Override
    public boolean seekToLast() {
        this.key = null;
        return this.tableIterator.seekToLast();
    }

    @Override
    public boolean next() {
        this.key = null;
        return this.tableIterator.next();
    }

    @Override
    public boolean prev() {
        this.key = null;
        return this.tableIterator.prev();
    }

    @Override
    public InternalKey key() {
        if (this.key == null) {
            this.key = new InternalKey((Slice)this.tableIterator.key());
        }
        return this.key;
    }

    @Override
    public Slice value() {
        return (Slice)this.tableIterator.value();
    }

    public String toString() {
        return "InternalTableIterator{fromIterator=" + this.tableIterator + '}';
    }

    @Override
    public void close() throws IOException {
        this.key = null;
        this.tableIterator.close();
    }
}

