/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.impl.FileMetaData;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.InternalKeyComparator;
import org.iq80.leveldb.impl.KeyMatchingLookup;
import org.iq80.leveldb.impl.LookupKey;
import org.iq80.leveldb.impl.LookupResult;
import org.iq80.leveldb.impl.ReadStats;
import org.iq80.leveldb.impl.TableCache;
import org.iq80.leveldb.impl.ValueType;
import org.iq80.leveldb.iterator.InternalIterator;
import org.iq80.leveldb.iterator.InternalTableIterator;
import org.iq80.leveldb.iterator.MergingIterator;
import org.iq80.leveldb.iterator.SeekingIterator;
import org.iq80.leveldb.iterator.SeekingIterators;
import org.iq80.leveldb.table.UserComparator;
import org.iq80.leveldb.util.SafeListBuilder;
import org.iq80.leveldb.util.Slice;

public class Level {
    public static final Comparator<FileMetaData> NEWEST_FIRST = (fileMetaData, fileMetaData1) -> (int)(fileMetaData1.getNumber() - fileMetaData.getNumber());
    private final int levelNumber;
    private final TableCache tableCache;
    private final InternalKeyComparator internalKeyComparator;
    private final List<FileMetaData> files;

    public Level(int levelNumber, Collection<FileMetaData> files, TableCache tableCache, InternalKeyComparator internalKeyComparator) {
        Preconditions.checkArgument((levelNumber >= 0 ? 1 : 0) != 0, (Object)"levelNumber is negative");
        Objects.requireNonNull(files, "files is null");
        Objects.requireNonNull(tableCache, "tableCache is null");
        Objects.requireNonNull(internalKeyComparator, "internalKeyComparator is null");
        this.files = new ArrayList<FileMetaData>(files);
        this.tableCache = tableCache;
        this.internalKeyComparator = internalKeyComparator;
        this.levelNumber = levelNumber;
    }

    public int getLevelNumber() {
        return this.levelNumber;
    }

    public List<FileMetaData> getFiles() {
        return this.files;
    }

    public InternalIterator iterator(ReadOptions options) throws IOException {
        if (this.levelNumber == 0) {
            try (SafeListBuilder<InternalTableIterator> builder = SafeListBuilder.builder();){
                for (FileMetaData file : this.files) {
                    builder.add(this.tableCache.newIterator(file, options));
                }
                MergingIterator mergingIterator = new MergingIterator(builder.build(), this.internalKeyComparator);
                return mergingIterator;
            }
        }
        return Level.createLevelConcatIterator(this.tableCache, this.files, this.internalKeyComparator, options);
    }

    public static InternalIterator createLevelConcatIterator(TableCache tableCache, List<FileMetaData> files, InternalKeyComparator internalKeyComparator, ReadOptions options) {
        SeekingIterator<InternalKey, FileMetaData> iterator = SeekingIterators.fromSortedList(files, FileMetaData::getLargest, f -> f, internalKeyComparator);
        return SeekingIterators.twoLevelInternalIterator(iterator, fileMetaData -> {
            try {
                return tableCache.newIterator((FileMetaData)fileMetaData, options);
            }
            catch (IOException e) {
                throw new DBException((Throwable)e);
            }
        }, () -> {});
    }

    public LookupResult get(ReadOptions options, LookupKey key, ReadStats readStats, ReadStats lasReadFile) {
        if (this.files.isEmpty()) {
            return null;
        }
        List<FileMetaData> fileMetaDataList = this.getFilesForKey(key.getUserKey(), key.getInternalKey());
        if (fileMetaDataList.isEmpty()) {
            return null;
        }
        for (FileMetaData fileMetaData : fileMetaDataList) {
            if (lasReadFile.getSeekFile() != null && readStats.getSeekFile() == null) {
                readStats.setSeekFile(lasReadFile.getSeekFile());
                readStats.setSeekFileLevel(lasReadFile.getSeekFileLevel());
            }
            lasReadFile.setSeekFile(fileMetaData);
            lasReadFile.setSeekFileLevel(this.levelNumber);
            LookupResult lookupResult = this.tableCache.get(options, key.getInternalKey().encode(), fileMetaData, new KeyMatchingLookup(key));
            if (lookupResult == null) continue;
            return lookupResult;
        }
        return null;
    }

    public List<FileMetaData> getFilesForKey(Slice userKey, InternalKey internalKey) {
        UserComparator userComparator = this.internalKeyComparator.getUserComparator();
        if (this.levelNumber == 0) {
            ArrayList<FileMetaData> fileMetaDataList = new ArrayList<FileMetaData>(this.files.size());
            for (FileMetaData fileMetaData : this.files) {
                if (userComparator.compare(userKey, fileMetaData.getSmallest().getUserKey()) < 0 || userComparator.compare(userKey, fileMetaData.getLargest().getUserKey()) > 0) continue;
                fileMetaDataList.add(fileMetaData);
            }
            if (fileMetaDataList.isEmpty()) {
                return Collections.emptyList();
            }
            fileMetaDataList.sort(NEWEST_FIRST);
            return fileMetaDataList;
        }
        int index = this.findFile(internalKey);
        if (index >= this.files.size()) {
            return Collections.emptyList();
        }
        FileMetaData fileMetaData = this.files.get(index);
        if (userComparator.compare(userKey, fileMetaData.getSmallest().getUserKey()) < 0) {
            return Collections.emptyList();
        }
        return Collections.singletonList(fileMetaData);
    }

    public boolean someFileOverlapsRange(boolean disjointSortedFiles, Slice smallestUserKey, Slice largestUserKey) {
        UserComparator userComparator = this.internalKeyComparator.getUserComparator();
        if (!disjointSortedFiles) {
            for (FileMetaData file : this.files) {
                if (this.afterFile(userComparator, smallestUserKey, file) || this.beforeFile(userComparator, largestUserKey, file)) continue;
                return true;
            }
            return false;
        }
        int index = 0;
        if (smallestUserKey != null) {
            InternalKey smallestInternalKey = new InternalKey(smallestUserKey, 0xFFFFFFFFFFFFFFL, ValueType.VALUE);
            index = this.findFile(smallestInternalKey);
        }
        if (index >= this.files.size()) {
            return false;
        }
        return !this.beforeFile(userComparator, largestUserKey, this.files.get(index));
    }

    private boolean beforeFile(UserComparator userComparator, Slice userKey, FileMetaData file) {
        return userKey != null && userComparator.compare(userKey, file.getSmallest().getUserKey()) < 0;
    }

    private boolean afterFile(UserComparator userComparator, Slice userKey, FileMetaData file) {
        return userKey != null && userComparator.compare(userKey, file.getLargest().getUserKey()) > 0;
    }

    @VisibleForTesting
    int findFile(InternalKey targetKey) {
        int left = 0;
        int right = this.files.size();
        while (left < right) {
            int mid = (left + right) / 2;
            if (this.internalKeyComparator.compare(this.files.get(mid).getLargest(), targetKey) < 0) {
                left = mid + 1;
                continue;
            }
            right = mid;
        }
        return right;
    }

    public void addFile(FileMetaData fileMetaData) {
        this.files.add(fileMetaData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Level");
        sb.append("{levelNumber=").append(this.levelNumber);
        sb.append(", files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

