/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Preconditions;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.LookupKey;
import org.iq80.leveldb.impl.LookupResult;
import org.iq80.leveldb.impl.ValueType;
import org.iq80.leveldb.table.KeyValueFunction;
import org.iq80.leveldb.util.Slice;

public class KeyMatchingLookup
implements KeyValueFunction<LookupResult> {
    private LookupKey key;

    KeyMatchingLookup(LookupKey key) {
        this.key = key;
    }

    @Override
    public LookupResult apply(Slice internalKey1, Slice value) {
        Preconditions.checkState((internalKey1 != null ? 1 : 0) != 0, (String)"Corrupt key for %s", (Object)this.key);
        InternalKey internalKey = new InternalKey(internalKey1);
        if (this.key.getUserKey().equals(internalKey.getUserKey())) {
            if (internalKey.getValueType() == ValueType.DELETION) {
                return LookupResult.deleted(this.key);
            }
            if (internalKey.getValueType() == ValueType.VALUE) {
                return LookupResult.ok(this.key, value);
            }
        }
        return null;
    }
}

