/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.iq80.leveldb.XFilterPolicy;
import org.iq80.leveldb.table.FilterPolicy;
import org.iq80.leveldb.util.Slice;

final class InternalFilterPolicy
implements FilterPolicy {
    private static final Function<Slice, Slice> EXTRACT_USER_KEY = InternalFilterPolicy::extractUserKey;
    private FilterPolicy userPolicy;

    private InternalFilterPolicy(FilterPolicy userPolicy) {
        this.userPolicy = userPolicy;
    }

    static InternalFilterPolicy convert(XFilterPolicy policy) {
        Preconditions.checkArgument((policy == null || policy instanceof FilterPolicy ? 1 : 0) != 0, (Object)"Filter policy must implement Java interface FilterPolicy");
        if (policy instanceof InternalFilterPolicy) {
            return (InternalFilterPolicy)policy;
        }
        return policy == null ? null : new InternalFilterPolicy((FilterPolicy)policy);
    }

    @Override
    public String name() {
        return this.userPolicy.name();
    }

    @Override
    public byte[] createFilter(List<Slice> keys) {
        return this.userPolicy.createFilter(Lists.transform(keys, EXTRACT_USER_KEY));
    }

    @Override
    public boolean keyMayMatch(Slice key, Slice filter) {
        return this.userPolicy.keyMayMatch(InternalFilterPolicy.extractUserKey(key), filter);
    }

    private static Slice extractUserKey(Slice key) {
        Preconditions.checkArgument((key.length() >= 8 ? 1 : 0) != 0);
        return key.slice(0, key.length() - 8);
    }
}

