/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.fileenv;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.iq80.leveldb.env.SequentialFile;
import org.iq80.leveldb.util.SliceOutput;

class SequentialFileImpl
implements SequentialFile {
    private final FileInputStream inputStream;

    private SequentialFileImpl(FileInputStream inputStream) {
        this.inputStream = inputStream;
    }

    public static SequentialFile open(File file) throws IOException {
        return new SequentialFileImpl(new FileInputStream(file));
    }

    @Override
    public void skip(long n) throws IOException {
        Preconditions.checkState((n >= 0L ? 1 : 0) != 0, (Object)"n must be positive");
        if (this.inputStream.skip(n) != n) {
            throw new IOException(this.inputStream + " as not enough bytes to skip");
        }
    }

    @Override
    public int read(int atMost, SliceOutput destination) throws IOException {
        return destination.writeBytes(this.inputStream, atMost);
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

