/*
 * Decompiled with CFR 0.152.
 */
package io.github.oshai.kotlinlogging.jul.internal;

import io.github.oshai.kotlinlogging.DelegatingKLogger;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KLoggingEventBuilder;
import io.github.oshai.kotlinlogging.Level;
import io.github.oshai.kotlinlogging.Marker;
import io.github.oshai.kotlinlogging.jul.internal.JulLoggerWrapper$WhenMappings;
import java.util.logging.Logger;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J3\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\r0\u0013\u00a2\u0006\u0002\b\u0015H\u0016J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u000fH\u0002R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lio/github/oshai/kotlinlogging/jul/internal/JulLoggerWrapper;", "Lio/github/oshai/kotlinlogging/KLogger;", "Lio/github/oshai/kotlinlogging/DelegatingKLogger;", "Ljava/util/logging/Logger;", "underlyingLogger", "(Ljava/util/logging/Logger;)V", "name", "", "getName", "()Ljava/lang/String;", "getUnderlyingLogger", "()Ljava/util/logging/Logger;", "at", "", "level", "Lio/github/oshai/kotlinlogging/Level;", "marker", "Lio/github/oshai/kotlinlogging/Marker;", "block", "Lkotlin/Function1;", "Lio/github/oshai/kotlinlogging/KLoggingEventBuilder;", "Lkotlin/ExtensionFunctionType;", "isLoggingEnabledFor", "", "toJULLevel", "Ljava/util/logging/Level;", "kotlin-logging"})
public final class JulLoggerWrapper
implements KLogger,
DelegatingKLogger<Logger> {
    @NotNull
    private final Logger underlyingLogger;

    @Override
    @NotNull
    public String getName() {
        String string = this.getUnderlyingLogger().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"underlyingLogger.name");
        return string;
    }

    @Override
    public void at(@NotNull Level level, @Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (this.isLoggingEnabledFor(level, null)) {
            KLoggingEventBuilder kLoggingEventBuilder = new KLoggingEventBuilder();
            block.invoke((Object)kLoggingEventBuilder);
            KLoggingEventBuilder $this$run = kLoggingEventBuilder;
            boolean bl = false;
            this.getUnderlyingLogger().log(this.toJULLevel(level), $this$run.getMessage(), $this$run.getCause());
        }
    }

    @Override
    public boolean isLoggingEnabledFor(@NotNull Level level, @Nullable Marker marker) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        return this.getUnderlyingLogger().isLoggable(this.toJULLevel(level));
    }

    private final java.util.logging.Level toJULLevel(Level $this$toJULLevel) {
        java.util.logging.Level level;
        switch (JulLoggerWrapper$WhenMappings.$EnumSwitchMapping$0[$this$toJULLevel.ordinal()]) {
            case 1: {
                java.util.logging.Level level2 = java.util.logging.Level.FINEST;
                level = level2;
                Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"Level.FINEST");
                break;
            }
            case 2: {
                java.util.logging.Level level3 = java.util.logging.Level.FINE;
                level = level3;
                Intrinsics.checkNotNullExpressionValue((Object)level3, (String)"Level.FINE");
                break;
            }
            case 3: {
                java.util.logging.Level level4 = java.util.logging.Level.INFO;
                level = level4;
                Intrinsics.checkNotNullExpressionValue((Object)level4, (String)"Level.INFO");
                break;
            }
            case 4: {
                java.util.logging.Level level5 = java.util.logging.Level.WARNING;
                level = level5;
                Intrinsics.checkNotNullExpressionValue((Object)level5, (String)"Level.WARNING");
                break;
            }
            case 5: {
                java.util.logging.Level level6 = java.util.logging.Level.SEVERE;
                level = level6;
                Intrinsics.checkNotNullExpressionValue((Object)level6, (String)"Level.SEVERE");
                break;
            }
            case 6: {
                java.util.logging.Level level7 = java.util.logging.Level.OFF;
                level = level7;
                Intrinsics.checkNotNullExpressionValue((Object)level7, (String)"Level.OFF");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        java.util.logging.Level julLevel = level;
        return julLevel;
    }

    @Override
    @NotNull
    public Logger getUnderlyingLogger() {
        return this.underlyingLogger;
    }

    public JulLoggerWrapper(@NotNull Logger underlyingLogger) {
        Intrinsics.checkNotNullParameter((Object)underlyingLogger, (String)"underlyingLogger");
        this.underlyingLogger = underlyingLogger;
    }

    @Override
    public void trace(@NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        KLogger.DefaultImpls.trace((KLogger)this, message);
    }

    @Override
    public void trace(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        KLogger.DefaultImpls.trace((KLogger)this, throwable, message);
    }

    @Override
    public void trace(@Nullable Throwable throwable, @Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        KLogger.DefaultImpls.trace((KLogger)this, throwable, marker, message);
    }

    @Override
    @Deprecated(message="use trace instead", replaceWith=@ReplaceWith(imports={}, expression="trace(null, marker, msg)"))
    public void trace(@Nullable Marker marker, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        KLogger.DefaultImpls.trace((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="use trace instead", replaceWith=@ReplaceWith(imports={}, expression="trace(t, marker, msg)"))
    public void trace(@Nullable Marker marker, @Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        KLogger.DefaultImpls.trace((KLogger)this, marker, t, msg);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(imports={}, expression="trace { \"$msg\"}"))
    public void trace(@Nullable String msg) {
        KLogger.DefaultImpls.trace((KLogger)this, msg);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(imports={}, expression="trace { \"$msg $arg\"}"))
    public void trace(@Nullable String msg, @Nullable Object arg) {
        KLogger.DefaultImpls.trace((KLogger)this, msg, arg);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(imports={}, expression="trace { \"$msg $arg1 $arg2\"}"))
    public void trace(@Nullable String msg, @Nullable Object arg1, @Nullable Object arg2) {
        KLogger.DefaultImpls.trace((KLogger)this, msg, arg1, arg2);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(imports={}, expression="trace { \"$msg $arguments\"}"))
    public void trace(@Nullable String msg, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        KLogger.DefaultImpls.trace((KLogger)this, msg, arguments);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(imports={}, expression="trace(t) { \"$msg\"}"))
    public void trace(@Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.trace((KLogger)this, msg, t);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(imports={}, expression="trace(marker) { \"$msg\"}"))
    public void trace(@Nullable Marker marker, @Nullable String msg) {
        KLogger.DefaultImpls.trace((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(imports={}, expression="trace(marker) { \"$msg $arg\"}"))
    public void trace(@Nullable Marker marker, @Nullable String msg, @Nullable Object arg) {
        KLogger.DefaultImpls.trace((KLogger)this, marker, msg, arg);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(imports={}, expression="trace(marker) { \"$msg $arg1 $arg2\"}"))
    public void trace(@Nullable Marker marker, @Nullable String msg, @Nullable Object arg1, @Nullable Object arg2) {
        KLogger.DefaultImpls.trace((KLogger)this, marker, msg, arg1, arg2);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(imports={}, expression="trace(marker) { \"$msg $arguments\"}"))
    public void trace(@Nullable Marker marker, @Nullable String msg, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        KLogger.DefaultImpls.trace((KLogger)this, marker, msg, arguments);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(imports={}, expression="trace(t, marker) { \"$msg\"}"))
    public void trace(@Nullable Marker marker, @Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.trace((KLogger)this, marker, msg, t);
    }

    @Override
    public void debug(@NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        KLogger.DefaultImpls.debug((KLogger)this, message);
    }

    @Override
    public void debug(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        KLogger.DefaultImpls.debug((KLogger)this, throwable, message);
    }

    @Override
    public void debug(@Nullable Throwable throwable, @Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        KLogger.DefaultImpls.debug((KLogger)this, throwable, marker, message);
    }

    @Override
    @Deprecated(message="use debug instead", replaceWith=@ReplaceWith(imports={}, expression="debug(null, marker, msg)"))
    public void debug(@Nullable Marker marker, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        KLogger.DefaultImpls.debug((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="use debug instead", replaceWith=@ReplaceWith(imports={}, expression="debug(t, marker, msg)"))
    public void debug(@Nullable Marker marker, @Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        KLogger.DefaultImpls.debug((KLogger)this, marker, t, msg);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(imports={}, expression="debug { msg }"))
    public void debug(@Nullable String msg) {
        KLogger.DefaultImpls.debug((KLogger)this, msg);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(imports={}, expression="debug { \"$msg $arg\"}"))
    public void debug(@Nullable String msg, @Nullable Object arg) {
        KLogger.DefaultImpls.debug((KLogger)this, msg, arg);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(imports={}, expression="debug { \"$msg $arg1 $arg2\"}"))
    public void debug(@Nullable String msg, @Nullable Object arg1, @Nullable Object arg2) {
        KLogger.DefaultImpls.debug((KLogger)this, msg, arg1, arg2);
    }

    @Override
    @Deprecated(message="Use debug {} instead")
    public void debug(@Nullable String msg, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        KLogger.DefaultImpls.debug((KLogger)this, msg, arguments);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(imports={}, expression="debug(t) { \"$msg\"}"))
    public void debug(@Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.debug((KLogger)this, msg, t);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(imports={}, expression="debug(marker) { \"$msg\"}"))
    public void debug(@Nullable Marker marker, @Nullable String msg) {
        KLogger.DefaultImpls.debug((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(imports={}, expression="debug(marker) { \"$msg $arg\"}"))
    public void debug(@Nullable Marker marker, @Nullable String msg, @Nullable Object arg) {
        KLogger.DefaultImpls.debug((KLogger)this, marker, msg, arg);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(imports={}, expression="debug(marker) { \"$msg $arg1 $arg2\"}"))
    public void debug(@Nullable Marker marker, @Nullable String msg, @Nullable Object arg1, @Nullable Object arg2) {
        KLogger.DefaultImpls.debug((KLogger)this, marker, msg, arg1, arg2);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(imports={}, expression="debug(marker) { \"$msg $arguments\"}"))
    public void debug(@Nullable Marker marker, @Nullable String msg, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        KLogger.DefaultImpls.debug((KLogger)this, marker, msg, arguments);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(imports={}, expression="debug(t, marker) { \"$msg\"}"))
    public void debug(@Nullable Marker marker, @Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.debug((KLogger)this, marker, msg, t);
    }

    @Override
    public void info(@NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        KLogger.DefaultImpls.info((KLogger)this, message);
    }

    @Override
    public void info(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        KLogger.DefaultImpls.info((KLogger)this, throwable, message);
    }

    @Override
    public void info(@Nullable Throwable throwable, @Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        KLogger.DefaultImpls.info((KLogger)this, throwable, marker, message);
    }

    @Override
    @Deprecated(message="use info instead", replaceWith=@ReplaceWith(imports={}, expression="info(null, marker, msg)"))
    public void info(@Nullable Marker marker, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        KLogger.DefaultImpls.info((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="use info instead", replaceWith=@ReplaceWith(imports={}, expression="info(t, marker, msg)"))
    public void info(@Nullable Marker marker, @Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        KLogger.DefaultImpls.info((KLogger)this, marker, t, msg);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(imports={}, expression="info { msg }"))
    public void info(@Nullable String msg) {
        KLogger.DefaultImpls.info((KLogger)this, msg);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(imports={}, expression="info { \"$msg $arg\"}"))
    public void info(@Nullable String msg, @Nullable Object arg) {
        KLogger.DefaultImpls.info((KLogger)this, msg, arg);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(imports={}, expression="info { \"$msg $arg1 $arg2\"}"))
    public void info(@Nullable String msg, @Nullable Object arg1, @Nullable Object arg2) {
        KLogger.DefaultImpls.info((KLogger)this, msg, arg1, arg2);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(imports={}, expression="info { \"$msg $arguments\"}"))
    public void info(@Nullable String msg, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        KLogger.DefaultImpls.info((KLogger)this, msg, arguments);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(imports={}, expression="info(t) { \"$msg\"}"))
    public void info(@Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.info((KLogger)this, msg, t);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(imports={}, expression="info(marker) { \"$msg\"}"))
    public void info(@Nullable Marker marker, @Nullable String msg) {
        KLogger.DefaultImpls.info((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(imports={}, expression="info(marker) { \"$msg $arg\"}"))
    public void info(@Nullable Marker marker, @Nullable String msg, @Nullable Object arg) {
        KLogger.DefaultImpls.info((KLogger)this, marker, msg, arg);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(imports={}, expression="info(marker) { \"$msg $arg1 $arg2\"}"))
    public void info(@Nullable Marker marker, @Nullable String msg, @Nullable Object arg1, @Nullable Object arg2) {
        KLogger.DefaultImpls.info((KLogger)this, marker, msg, arg1, arg2);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(imports={}, expression="info(marker) { \"$msg $arguments\"}"))
    public void info(@Nullable Marker marker, @Nullable String msg, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        KLogger.DefaultImpls.info((KLogger)this, marker, msg, arguments);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(imports={}, expression="info(t, marker) { \"$msg\"}"))
    public void info(@Nullable Marker marker, @Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.info((KLogger)this, marker, msg, t);
    }

    @Override
    public void warn(@NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        KLogger.DefaultImpls.warn((KLogger)this, message);
    }

    @Override
    public void warn(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        KLogger.DefaultImpls.warn((KLogger)this, throwable, message);
    }

    @Override
    public void warn(@Nullable Throwable throwable, @Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        KLogger.DefaultImpls.warn((KLogger)this, throwable, marker, message);
    }

    @Override
    @Deprecated(message="use warn instead", replaceWith=@ReplaceWith(imports={}, expression="warn(null, marker, msg)"))
    public void warn(@Nullable Marker marker, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        KLogger.DefaultImpls.warn((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="use warn instead", replaceWith=@ReplaceWith(imports={}, expression="warn(t, marker, msg)"))
    public void warn(@Nullable Marker marker, @Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        KLogger.DefaultImpls.warn((KLogger)this, marker, t, msg);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(imports={}, expression="warn { msg }"))
    public void warn(@Nullable String msg) {
        KLogger.DefaultImpls.warn((KLogger)this, msg);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(imports={}, expression="warn { \"$msg $arg\"}"))
    public void warn(@Nullable String msg, @Nullable Object arg) {
        KLogger.DefaultImpls.warn((KLogger)this, msg, arg);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(imports={}, expression="warn { \"$msg $arguments\"}"))
    public void warn(@Nullable String msg, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        KLogger.DefaultImpls.warn((KLogger)this, msg, arguments);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(imports={}, expression="warn { \"$msg $arg1 $arg2\"}"))
    public void warn(@Nullable String msg, @Nullable Object arg1, @Nullable Object arg2) {
        KLogger.DefaultImpls.warn((KLogger)this, msg, arg1, arg2);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(imports={}, expression="warn(t) { \"$msg\"}"))
    public void warn(@Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.warn((KLogger)this, msg, t);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(imports={}, expression="warn(marker) { \"$msg\"}"))
    public void warn(@Nullable Marker marker, @Nullable String msg) {
        KLogger.DefaultImpls.warn((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(imports={}, expression="warn(marker) { \"$msg $arg\"}"))
    public void warn(@Nullable Marker marker, @Nullable String msg, @Nullable Object arg) {
        KLogger.DefaultImpls.warn((KLogger)this, marker, msg, arg);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(imports={}, expression="warn(marker) { \"$msg $arg1 $arg2\"}"))
    public void warn(@Nullable Marker marker, @Nullable String msg, @Nullable Object arg1, @Nullable Object arg2) {
        KLogger.DefaultImpls.warn((KLogger)this, marker, msg, arg1, arg2);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(imports={}, expression="warn(marker) { \"$msg $arguments\"}"))
    public void warn(@Nullable Marker marker, @Nullable String msg, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        KLogger.DefaultImpls.warn((KLogger)this, marker, msg, arguments);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(imports={}, expression="warn(t, marker) { \"$msg\"}"))
    public void warn(@Nullable Marker marker, @Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.warn((KLogger)this, marker, msg, t);
    }

    @Override
    public void error(@NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        KLogger.DefaultImpls.error((KLogger)this, message);
    }

    @Override
    public void error(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        KLogger.DefaultImpls.error((KLogger)this, throwable, message);
    }

    @Override
    public void error(@Nullable Throwable throwable, @Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        KLogger.DefaultImpls.error((KLogger)this, throwable, marker, message);
    }

    @Override
    @Deprecated(message="use error instead", replaceWith=@ReplaceWith(imports={}, expression="error(null, marker, msg)"))
    public void error(@Nullable Marker marker, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        KLogger.DefaultImpls.error((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="use error instead", replaceWith=@ReplaceWith(imports={}, expression="error(t, marker, msg)"))
    public void error(@Nullable Marker marker, @Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        KLogger.DefaultImpls.error((KLogger)this, marker, t, msg);
    }

    @Override
    @Deprecated(message="Use error {} instead", replaceWith=@ReplaceWith(imports={}, expression="error { msg }"))
    public void error(@Nullable String msg) {
        KLogger.DefaultImpls.error((KLogger)this, msg);
    }

    @Override
    @Deprecated(message="Use error {} instead", replaceWith=@ReplaceWith(imports={}, expression="error { \"$msg $arg\"}"))
    public void error(@Nullable String msg, @Nullable Object arg) {
        KLogger.DefaultImpls.error((KLogger)this, msg, arg);
    }

    @Override
    @Deprecated(message="Use error {} instead", replaceWith=@ReplaceWith(imports={}, expression="error { \"$msg $arg1 $arg2\"}"))
    public void error(@Nullable String msg, @Nullable Object arg1, @Nullable Object arg2) {
        KLogger.DefaultImpls.error((KLogger)this, msg, arg1, arg2);
    }

    @Override
    @Deprecated(message="Use error {} instead", replaceWith=@ReplaceWith(imports={}, expression="error { \"$msg $arguments\"}"))
    public void error(@Nullable String msg, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        KLogger.DefaultImpls.error((KLogger)this, msg, arguments);
    }

    @Override
    @Deprecated(message="Use error(t){} instead", replaceWith=@ReplaceWith(imports={}, expression="error(t) { \"$msg\"}"))
    public void error(@Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.error((KLogger)this, msg, t);
    }

    @Override
    @Deprecated(message="Use error(marker){} instead", replaceWith=@ReplaceWith(imports={}, expression="error(marker) { \"$msg\"}"))
    public void error(@Nullable Marker marker, @Nullable String msg) {
        KLogger.DefaultImpls.error((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="Use error(marker){} instead", replaceWith=@ReplaceWith(imports={}, expression="error(marker) { \"$msg $arg \"}"))
    public void error(@Nullable Marker marker, @Nullable String msg, @Nullable Object arg) {
        KLogger.DefaultImpls.error((KLogger)this, marker, msg, arg);
    }

    @Override
    @Deprecated(message="Use error(marker){} instead", replaceWith=@ReplaceWith(imports={}, expression="error(marker) { \"$msg $arg1 $arg2\"}"))
    public void error(@Nullable Marker marker, @Nullable String msg, @Nullable Object arg1, @Nullable Object arg2) {
        KLogger.DefaultImpls.error((KLogger)this, marker, msg, arg1, arg2);
    }

    @Override
    @Deprecated(message="Use error(marker){} instead", replaceWith=@ReplaceWith(imports={}, expression="error(marker) { \"$msg $arguments\"}"))
    public void error(@Nullable Marker marker, @Nullable String msg, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        KLogger.DefaultImpls.error((KLogger)this, marker, msg, arguments);
    }

    @Override
    @Deprecated(message="Use error instead", replaceWith=@ReplaceWith(imports={}, expression="error(t, marker, msg)"))
    public void error(@Nullable Marker marker, @Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.error((KLogger)this, marker, msg, t);
    }

    @Override
    public void atTrace(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        KLogger.DefaultImpls.atTrace(this, marker, block);
    }

    @Override
    public void atTrace(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        KLogger.DefaultImpls.atTrace(this, block);
    }

    @Override
    public void atDebug(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        KLogger.DefaultImpls.atDebug(this, marker, block);
    }

    @Override
    public void atDebug(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        KLogger.DefaultImpls.atDebug(this, block);
    }

    @Override
    public void atInfo(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        KLogger.DefaultImpls.atInfo(this, marker, block);
    }

    @Override
    public void atInfo(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        KLogger.DefaultImpls.atInfo(this, block);
    }

    @Override
    public void atWarn(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        KLogger.DefaultImpls.atWarn(this, marker, block);
    }

    @Override
    public void atWarn(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        KLogger.DefaultImpls.atWarn(this, block);
    }

    @Override
    public void atError(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        KLogger.DefaultImpls.atError(this, marker, block);
    }

    @Override
    public void atError(@NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        KLogger.DefaultImpls.atError(this, block);
    }

    @Override
    public void entry(Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        KLogger.DefaultImpls.entry(this, arguments);
    }

    @Override
    public void exit() {
        KLogger.DefaultImpls.exit(this);
    }

    @Override
    public <T> T exit(T result) {
        return KLogger.DefaultImpls.exit(this, result);
    }

    @Override
    @NotNull
    public <T extends Throwable> T throwing(@NotNull T throwable) {
        Intrinsics.checkNotNullParameter(throwable, (String)"throwable");
        return KLogger.DefaultImpls.throwing(this, throwable);
    }

    @Override
    public <T extends Throwable> void catching(@NotNull T throwable) {
        Intrinsics.checkNotNullParameter(throwable, (String)"throwable");
        KLogger.DefaultImpls.catching(this, throwable);
    }

    @Override
    public boolean isTraceEnabled(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isTraceEnabled(this, marker);
    }

    @Override
    public boolean isDebugEnabled(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isDebugEnabled(this, marker);
    }

    @Override
    public boolean isInfoEnabled(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isInfoEnabled(this, marker);
    }

    @Override
    public boolean isWarnEnabled(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isWarnEnabled(this, marker);
    }

    @Override
    public boolean isErrorEnabled(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isErrorEnabled(this, marker);
    }

    @Override
    public boolean isLoggingOff(@Nullable Marker marker) {
        return KLogger.DefaultImpls.isLoggingOff(this, marker);
    }

    @Override
    public boolean isTraceEnabled() {
        return KLogger.DefaultImpls.isTraceEnabled(this);
    }

    @Override
    public boolean isDebugEnabled() {
        return KLogger.DefaultImpls.isDebugEnabled(this);
    }

    @Override
    public boolean isInfoEnabled() {
        return KLogger.DefaultImpls.isInfoEnabled(this);
    }

    @Override
    public boolean isWarnEnabled() {
        return KLogger.DefaultImpls.isWarnEnabled(this);
    }

    @Override
    public boolean isErrorEnabled() {
        return KLogger.DefaultImpls.isErrorEnabled(this);
    }

    @Override
    public boolean isLoggingOff() {
        return KLogger.DefaultImpls.isLoggingOff(this);
    }
}

