(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kotlin-logging-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kotlin-logging-js-legacy'.");
    }
    root['kotlin-logging-js-legacy'] = factory(typeof this['kotlin-logging-js-legacy'] === 'undefined' ? {} : this['kotlin-logging-js-legacy'], kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var get_js = Kotlin.kotlin.js.get_js_1yb8b7$;
  var Enum = Kotlin.kotlin.Enum;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var throwISE = Kotlin.throwISE;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var toString = Kotlin.toString;
  var equals = Kotlin.equals;
  var Exception = Kotlin.kotlin.Exception;
  var Unit = Kotlin.kotlin.Unit;
  var getCallableRef = Kotlin.getCallableRef;
  Level.prototype = Object.create(Enum.prototype);
  Level.prototype.constructor = Level;
  function isEnabledForLevel($receiver, level) {
    var tmp$;
    switch (level.toInt()) {
      case 0:
        tmp$ = $receiver.isTraceEnabled;
        break;
      case 10:
        tmp$ = $receiver.isDebugEnabled;
        break;
      case 20:
        tmp$ = $receiver.isInfoEnabled;
        break;
      case 30:
        tmp$ = $receiver.isWarnEnabled;
        break;
      case 40:
        tmp$ = $receiver.isErrorEnabled;
        break;
      default:
        throw IllegalArgumentException_init('Level [' + level + '] not recognized.');
    }
    return tmp$;
  }
  function ActualKLogger() {
  }
  ActualKLogger.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ActualKLogger',
    interfaces: []
  };
  function KMarkerFactory() {
    KMarkerFactory_instance = this;
  }
  KMarkerFactory.prototype.getMarker_61zpoe$ = function (name) {
    return new SimpleMarker(name);
  };
  KMarkerFactory.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'KMarkerFactory',
    interfaces: []
  };
  var KMarkerFactory_instance = null;
  function KMarkerFactory_getInstance() {
    if (KMarkerFactory_instance === null) {
      new KMarkerFactory();
    }
    return KMarkerFactory_instance;
  }
  function KotlinLogging() {
    KotlinLogging_instance = this;
  }
  KotlinLogging.prototype.logger_o14v8n$ = function (func) {
    return this.logger_61zpoe$(get_js(Kotlin.getKClassFromExpression(func)).name);
  };
  KotlinLogging.prototype.logger_61zpoe$ = function (name) {
    return new KLoggerJS(name);
  };
  KotlinLogging.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'KotlinLogging',
    interfaces: []
  };
  var KotlinLogging_instance = null;
  function KotlinLogging_getInstance() {
    if (KotlinLogging_instance === null) {
      new KotlinLogging();
    }
    return KotlinLogging_instance;
  }
  function Level(name, ordinal, levelInt, levelStr) {
    Enum.call(this);
    this.levelInt_ggqe4g$_0 = levelInt;
    this.levelStr_ggwwe6$_0 = levelStr;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Level_initFields() {
    Level_initFields = function () {
    };
    Level$TRACE_instance = new Level('TRACE', 0, 0, 'TRACE');
    Level$DEBUG_instance = new Level('DEBUG', 1, 10, 'DEBUG');
    Level$INFO_instance = new Level('INFO', 2, 20, 'INFO');
    Level$WARN_instance = new Level('WARN', 3, 30, 'WARN');
    Level$ERROR_instance = new Level('ERROR', 4, 40, 'ERROR');
  }
  var Level$TRACE_instance;
  function Level$TRACE_getInstance() {
    Level_initFields();
    return Level$TRACE_instance;
  }
  var Level$DEBUG_instance;
  function Level$DEBUG_getInstance() {
    Level_initFields();
    return Level$DEBUG_instance;
  }
  var Level$INFO_instance;
  function Level$INFO_getInstance() {
    Level_initFields();
    return Level$INFO_instance;
  }
  var Level$WARN_instance;
  function Level$WARN_getInstance() {
    Level_initFields();
    return Level$WARN_instance;
  }
  var Level$ERROR_instance;
  function Level$ERROR_getInstance() {
    Level_initFields();
    return Level$ERROR_instance;
  }
  Level.prototype.toInt = function () {
    return this.levelInt_ggqe4g$_0;
  };
  Level.prototype.toString = function () {
    return this.levelStr_ggwwe6$_0;
  };
  Level.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Level',
    interfaces: [Enum]
  };
  function Level$values() {
    return [Level$TRACE_getInstance(), Level$DEBUG_getInstance(), Level$INFO_getInstance(), Level$WARN_getInstance(), Level$ERROR_getInstance()];
  }
  Level.values = Level$values;
  function Level$valueOf(name) {
    switch (name) {
      case 'TRACE':
        return Level$TRACE_getInstance();
      case 'DEBUG':
        return Level$DEBUG_getInstance();
      case 'INFO':
        return Level$INFO_getInstance();
      case 'WARN':
        return Level$WARN_getInstance();
      case 'ERROR':
        return Level$ERROR_getInstance();
      default:
        throwISE('No enum constant io.github.oshai.Level.' + name);
    }
  }
  Level.valueOf_61zpoe$ = Level$valueOf;
  function Levels() {
    Levels_instance = this;
    this.TRACE_INT = 0;
    this.DEBUG_INT = 10;
    this.INFO_INT = 20;
    this.WARN_INT = 30;
    this.ERROR_INT = 40;
  }
  Levels.prototype.intToLevel_za3lpa$ = function (levelInt) {
    var tmp$;
    switch (levelInt) {
      case 0:
        tmp$ = Level$TRACE_getInstance();
        break;
      case 10:
        tmp$ = Level$DEBUG_getInstance();
        break;
      case 20:
        tmp$ = Level$INFO_getInstance();
        break;
      case 30:
        tmp$ = Level$WARN_getInstance();
        break;
      case 40:
        tmp$ = Level$ERROR_getInstance();
        break;
      default:
        throw IllegalArgumentException_init('Level integer [' + levelInt + '] not recognized.');
    }
    return tmp$;
  };
  Levels.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Levels',
    interfaces: []
  };
  var Levels_instance = null;
  function Levels_getInstance() {
    if (Levels_instance === null) {
      new Levels();
    }
    return Levels_instance;
  }
  function Marker() {
  }
  Marker.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Marker',
    interfaces: []
  };
  function SimpleMarker(name) {
    this.name_0 = name;
  }
  SimpleMarker.prototype.getName = function () {
    return this.name_0;
  };
  SimpleMarker.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SimpleMarker',
    interfaces: [Marker]
  };
  SimpleMarker.prototype.component1_0 = function () {
    return this.name_0;
  };
  SimpleMarker.prototype.copy_61zpoe$ = function (name) {
    return new SimpleMarker(name === void 0 ? this.name_0 : name);
  };
  SimpleMarker.prototype.toString = function () {
    return 'SimpleMarker(name=' + Kotlin.toString(this.name_0) + ')';
  };
  SimpleMarker.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.name_0) | 0;
    return result;
  };
  SimpleMarker.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.name_0, other.name_0))));
  };
  var toStringSafe = defineInlineFunction('kotlin-logging-js-legacy.io.github.oshai.internal.toStringSafe_qhgloa$', wrapFunction(function () {
    var toString = Kotlin.toString;
    var internal = _.io.github.oshai.internal;
    var Exception = Kotlin.kotlin.Exception;
    return function ($receiver) {
      var tmp$;
      try {
        tmp$ = toString($receiver());
      } catch (e) {
        if (Kotlin.isType(e, Exception)) {
          tmp$ = internal.DefaultErrorMessageProducer.getErrorLog_3lhtaa$(e);
        } else
          throw e;
      }
      return tmp$;
    };
  }));
  function DefaultErrorMessageProducer() {
    DefaultErrorMessageProducer_instance = this;
  }
  DefaultErrorMessageProducer.prototype.getErrorLog_3lhtaa$ = function (e) {
    return 'Log message invocation failed: ' + e;
  };
  DefaultErrorMessageProducer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'DefaultErrorMessageProducer',
    interfaces: []
  };
  var DefaultErrorMessageProducer_instance = null;
  function DefaultErrorMessageProducer_getInstance() {
    if (DefaultErrorMessageProducer_instance === null) {
      new DefaultErrorMessageProducer();
    }
    return DefaultErrorMessageProducer_instance;
  }
  function Appender() {
  }
  Appender.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Appender',
    interfaces: []
  };
  function ConsoleOutputAppender() {
    ConsoleOutputAppender_instance = this;
  }
  ConsoleOutputAppender.prototype.trace_s8jyv4$ = function (message) {
    console.log(message);
  };
  ConsoleOutputAppender.prototype.debug_s8jyv4$ = function (message) {
    console.log(message);
  };
  ConsoleOutputAppender.prototype.info_s8jyv4$ = function (message) {
    console.info(message);
  };
  ConsoleOutputAppender.prototype.warn_s8jyv4$ = function (message) {
    console.warn(message);
  };
  ConsoleOutputAppender.prototype.error_s8jyv4$ = function (message) {
    console.error(message);
  };
  ConsoleOutputAppender.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ConsoleOutputAppender',
    interfaces: [Appender]
  };
  var ConsoleOutputAppender_instance = null;
  function ConsoleOutputAppender_getInstance() {
    if (ConsoleOutputAppender_instance === null) {
      new ConsoleOutputAppender();
    }
    return ConsoleOutputAppender_instance;
  }
  function DefaultMessageFormatter() {
    DefaultMessageFormatter_instance = this;
  }
  DefaultMessageFormatter.prototype.formatMessage_temu8j$ = function (level, loggerName, msg) {
    var tmp$ = level.name + ': [' + loggerName + '] ';
    var tmp$_0;
    try {
      tmp$_0 = toString(msg());
    } catch (e) {
      if (Kotlin.isType(e, Exception)) {
        tmp$_0 = package$internal.DefaultErrorMessageProducer.getErrorLog_3lhtaa$(e);
      } else
        throw e;
    }
    return tmp$ + tmp$_0;
  };
  DefaultMessageFormatter.prototype.formatMessage_vbbtxv$ = function (level, loggerName, t, msg) {
    var tmp$ = level.name + ': [' + loggerName + '] ';
    var tmp$_0;
    try {
      tmp$_0 = toString(msg());
    } catch (e) {
      if (Kotlin.isType(e, Exception)) {
        tmp$_0 = package$internal.DefaultErrorMessageProducer.getErrorLog_3lhtaa$(e);
      } else
        throw e;
    }
    return tmp$ + tmp$_0 + this.throwableToString_0(t);
  };
  DefaultMessageFormatter.prototype.formatMessage_msna8x$ = function (level, loggerName, marker, msg) {
    var tmp$ = level.name + ': [' + loggerName + '] ' + toString(marker != null ? marker.getName() : null) + ' ';
    var tmp$_0;
    try {
      tmp$_0 = toString(msg());
    } catch (e) {
      if (Kotlin.isType(e, Exception)) {
        tmp$_0 = package$internal.DefaultErrorMessageProducer.getErrorLog_3lhtaa$(e);
      } else
        throw e;
    }
    return tmp$ + tmp$_0;
  };
  DefaultMessageFormatter.prototype.formatMessage_z61q1r$ = function (level, loggerName, marker, t, msg) {
    var tmp$ = level.name + ': [' + loggerName + '] ' + toString(marker != null ? marker.getName() : null) + ' ';
    var tmp$_0;
    try {
      tmp$_0 = toString(msg());
    } catch (e) {
      if (Kotlin.isType(e, Exception)) {
        tmp$_0 = package$internal.DefaultErrorMessageProducer.getErrorLog_3lhtaa$(e);
      } else
        throw e;
    }
    return tmp$ + tmp$_0 + this.throwableToString_0(t);
  };
  DefaultMessageFormatter.prototype.throwableToString_0 = function ($receiver) {
    if ($receiver == null) {
      return '';
    }
    var msg = '';
    var current = $receiver;
    while (current != null && !equals(current.cause, current)) {
      msg += ", Caused by: '" + toString(current.message) + "'";
      current = current.cause;
    }
    return msg;
  };
  DefaultMessageFormatter.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'DefaultMessageFormatter',
    interfaces: [Formatter]
  };
  var DefaultMessageFormatter_instance = null;
  function DefaultMessageFormatter_getInstance() {
    if (DefaultMessageFormatter_instance === null) {
      new DefaultMessageFormatter();
    }
    return DefaultMessageFormatter_instance;
  }
  function Formatter() {
  }
  Formatter.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Formatter',
    interfaces: []
  };
  function KotlinLoggingConfiguration() {
    KotlinLoggingConfiguration_instance = this;
    this.LOG_LEVEL = Level$INFO_getInstance();
    this.APPENDER = ConsoleOutputAppender_getInstance();
    this.FORMATTER = DefaultMessageFormatter_getInstance();
  }
  KotlinLoggingConfiguration.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'KotlinLoggingConfiguration',
    interfaces: []
  };
  var KotlinLoggingConfiguration_instance = null;
  function KotlinLoggingConfiguration_getInstance() {
    if (KotlinLoggingConfiguration_instance === null) {
      new KotlinLoggingConfiguration();
    }
    return KotlinLoggingConfiguration_instance;
  }
  function isLoggingEnabled($receiver) {
    return $receiver.ordinal >= KotlinLoggingConfiguration_getInstance().LOG_LEVEL.ordinal;
  }
  function KLoggerFactory() {
    KLoggerFactory_instance = this;
  }
  KLoggerFactory.prototype.logger_61zpoe$ = defineInlineFunction('kotlin-logging-js-legacy.io.github.oshai.internal.KLoggerFactory.logger_61zpoe$', wrapFunction(function () {
    var KLoggerJS_init = _.io.github.oshai.internal.KLoggerJS;
    return function (name) {
      return new KLoggerJS_init(name);
    };
  }));
  KLoggerFactory.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'KLoggerFactory',
    interfaces: []
  };
  var KLoggerFactory_instance = null;
  function KLoggerFactory_getInstance() {
    if (KLoggerFactory_instance === null) {
      new KLoggerFactory();
    }
    return KLoggerFactory_instance;
  }
  function KLoggerJS(name) {
    this.name_b2e7yx$_0 = name;
    this.isTraceEnabled_4ofcu6$_0 = isLoggingEnabled(Level$TRACE_getInstance());
    this.isDebugEnabled_menlf8$_0 = isLoggingEnabled(Level$DEBUG_getInstance());
    this.isInfoEnabled_7z8drb$_0 = isLoggingEnabled(Level$INFO_getInstance());
    this.isWarnEnabled_b383nl$_0 = isLoggingEnabled(Level$WARN_getInstance());
    this.isErrorEnabled_2yzkan$_0 = isLoggingEnabled(Level$ERROR_getInstance());
  }
  Object.defineProperty(KLoggerJS.prototype, 'name', {
    get: function () {
      return this.name_b2e7yx$_0;
    }
  });
  KLoggerJS.prototype.trace_nq59yw$ = function (msg) {
    this.logIfEnabled_0(Level$TRACE_getInstance(), msg, getCallableRef('trace', function ($receiver, p1) {
      return $receiver.trace_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  KLoggerJS.prototype.debug_nq59yw$ = function (msg) {
    this.logIfEnabled_0(Level$DEBUG_getInstance(), msg, getCallableRef('debug', function ($receiver, p1) {
      return $receiver.debug_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  KLoggerJS.prototype.info_nq59yw$ = function (msg) {
    this.logIfEnabled_0(Level$INFO_getInstance(), msg, getCallableRef('info', function ($receiver, p1) {
      return $receiver.info_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  KLoggerJS.prototype.warn_nq59yw$ = function (msg) {
    this.logIfEnabled_0(Level$WARN_getInstance(), msg, getCallableRef('warn', function ($receiver, p1) {
      return $receiver.warn_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  KLoggerJS.prototype.error_nq59yw$ = function (msg) {
    this.logIfEnabled_0(Level$ERROR_getInstance(), msg, getCallableRef('error', function ($receiver, p1) {
      return $receiver.error_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  KLoggerJS.prototype.trace_ca4k3s$ = function (t, msg) {
    this.logIfEnabled_1(Level$TRACE_getInstance(), msg, t, getCallableRef('trace', function ($receiver, p1) {
      return $receiver.trace_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  KLoggerJS.prototype.debug_ca4k3s$ = function (t, msg) {
    this.logIfEnabled_1(Level$DEBUG_getInstance(), msg, t, getCallableRef('debug', function ($receiver, p1) {
      return $receiver.debug_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  KLoggerJS.prototype.info_ca4k3s$ = function (t, msg) {
    this.logIfEnabled_1(Level$INFO_getInstance(), msg, t, getCallableRef('info', function ($receiver, p1) {
      return $receiver.info_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  KLoggerJS.prototype.warn_ca4k3s$ = function (t, msg) {
    this.logIfEnabled_1(Level$WARN_getInstance(), msg, t, getCallableRef('warn', function ($receiver, p1) {
      return $receiver.warn_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  KLoggerJS.prototype.error_ca4k3s$ = function (t, msg) {
    this.logIfEnabled_1(Level$ERROR_getInstance(), msg, t, getCallableRef('error', function ($receiver, p1) {
      return $receiver.error_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  KLoggerJS.prototype.trace_4svzwc$ = function (marker, msg) {
    this.logIfEnabled_2(Level$TRACE_getInstance(), marker, msg, getCallableRef('trace', function ($receiver, p1) {
      return $receiver.trace_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  KLoggerJS.prototype.debug_4svzwc$ = function (marker, msg) {
    this.logIfEnabled_2(Level$DEBUG_getInstance(), marker, msg, getCallableRef('debug', function ($receiver, p1) {
      return $receiver.debug_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  KLoggerJS.prototype.info_4svzwc$ = function (marker, msg) {
    this.logIfEnabled_2(Level$INFO_getInstance(), marker, msg, getCallableRef('info', function ($receiver, p1) {
      return $receiver.info_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  KLoggerJS.prototype.warn_4svzwc$ = function (marker, msg) {
    this.logIfEnabled_2(Level$WARN_getInstance(), marker, msg, getCallableRef('warn', function ($receiver, p1) {
      return $receiver.warn_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  KLoggerJS.prototype.error_4svzwc$ = function (marker, msg) {
    this.logIfEnabled_2(Level$ERROR_getInstance(), marker, msg, getCallableRef('error', function ($receiver, p1) {
      return $receiver.error_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  KLoggerJS.prototype.trace_gxrx1g$ = function (marker, t, msg) {
    this.logIfEnabled_3(Level$TRACE_getInstance(), marker, msg, t, getCallableRef('trace', function ($receiver, p1) {
      return $receiver.trace_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  KLoggerJS.prototype.debug_gxrx1g$ = function (marker, t, msg) {
    this.logIfEnabled_3(Level$DEBUG_getInstance(), marker, msg, t, getCallableRef('debug', function ($receiver, p1) {
      return $receiver.debug_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  KLoggerJS.prototype.info_gxrx1g$ = function (marker, t, msg) {
    this.logIfEnabled_3(Level$INFO_getInstance(), marker, msg, t, getCallableRef('info', function ($receiver, p1) {
      return $receiver.info_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  KLoggerJS.prototype.warn_gxrx1g$ = function (marker, t, msg) {
    this.logIfEnabled_3(Level$WARN_getInstance(), marker, msg, t, getCallableRef('warn', function ($receiver, p1) {
      return $receiver.warn_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  KLoggerJS.prototype.error_gxrx1g$ = function (marker, t, msg) {
    this.logIfEnabled_3(Level$ERROR_getInstance(), marker, msg, t, getCallableRef('error', function ($receiver, p1) {
      return $receiver.error_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  KLoggerJS.prototype.logIfEnabled_0 = function ($receiver, msg, logFunction) {
    if (isLoggingEnabled($receiver)) {
      logFunction(KotlinLoggingConfiguration_getInstance().FORMATTER.formatMessage_temu8j$($receiver, $receiver.name, msg));
    }
  };
  KLoggerJS.prototype.logIfEnabled_1 = function ($receiver, msg, t, logFunction) {
    if (isLoggingEnabled($receiver)) {
      logFunction(KotlinLoggingConfiguration_getInstance().FORMATTER.formatMessage_vbbtxv$($receiver, $receiver.name, t, msg));
    }
  };
  KLoggerJS.prototype.logIfEnabled_2 = function ($receiver, marker, msg, logFunction) {
    if (isLoggingEnabled($receiver)) {
      logFunction(KotlinLoggingConfiguration_getInstance().FORMATTER.formatMessage_msna8x$($receiver, $receiver.name, marker, msg));
    }
  };
  KLoggerJS.prototype.logIfEnabled_3 = function ($receiver, marker, msg, t, logFunction) {
    if (isLoggingEnabled($receiver)) {
      logFunction(KotlinLoggingConfiguration_getInstance().FORMATTER.formatMessage_z61q1r$($receiver, $receiver.name, marker, t, msg));
    }
  };
  function KLoggerJS$entry$lambda(closure$argArray) {
    return function () {
      return 'entry(' + closure$argArray + ')';
    };
  }
  KLoggerJS.prototype.entry_yhszz7$ = function (argArray) {
    this.logIfEnabled_0(Level$TRACE_getInstance(), KLoggerJS$entry$lambda(argArray), getCallableRef('trace', function ($receiver, p1) {
      return $receiver.trace_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  function KLoggerJS$exit$lambda() {
    return 'exit()';
  }
  KLoggerJS.prototype.exit = function () {
    this.logIfEnabled_0(Level$TRACE_getInstance(), KLoggerJS$exit$lambda, getCallableRef('trace', function ($receiver, p1) {
      return $receiver.trace_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  function KLoggerJS$exit$lambda_0(closure$result) {
    return function () {
      return 'exit(' + closure$result + ')';
    };
  }
  KLoggerJS.prototype.exit_mh5how$ = function (result) {
    this.logIfEnabled_0(Level$TRACE_getInstance(), KLoggerJS$exit$lambda_0(result), getCallableRef('trace', function ($receiver, p1) {
      return $receiver.trace_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
    return result;
  };
  function KLoggerJS$throwing$lambda(closure$throwable) {
    return function () {
      return 'throwing(' + closure$throwable;
    };
  }
  KLoggerJS.prototype.throwing_849n7l$ = function (throwable) {
    this.logIfEnabled_1(Level$ERROR_getInstance(), KLoggerJS$throwing$lambda(throwable), throwable, getCallableRef('error', function ($receiver, p1) {
      return $receiver.error_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
    return throwable;
  };
  function KLoggerJS$catching$lambda(closure$throwable) {
    return function () {
      return 'catching(' + closure$throwable;
    };
  }
  KLoggerJS.prototype.catching_849n7l$ = function (throwable) {
    this.logIfEnabled_1(Level$ERROR_getInstance(), KLoggerJS$catching$lambda(throwable), throwable, getCallableRef('error', function ($receiver, p1) {
      return $receiver.error_s8jyv4$(p1), Unit;
    }.bind(null, KotlinLoggingConfiguration_getInstance().APPENDER)));
  };
  Object.defineProperty(KLoggerJS.prototype, 'isTraceEnabled', {
    configurable: true,
    get: function () {
      return this.isTraceEnabled_4ofcu6$_0;
    }
  });
  Object.defineProperty(KLoggerJS.prototype, 'isDebugEnabled', {
    configurable: true,
    get: function () {
      return this.isDebugEnabled_menlf8$_0;
    }
  });
  Object.defineProperty(KLoggerJS.prototype, 'isInfoEnabled', {
    configurable: true,
    get: function () {
      return this.isInfoEnabled_7z8drb$_0;
    }
  });
  Object.defineProperty(KLoggerJS.prototype, 'isWarnEnabled', {
    configurable: true,
    get: function () {
      return this.isWarnEnabled_b383nl$_0;
    }
  });
  Object.defineProperty(KLoggerJS.prototype, 'isErrorEnabled', {
    configurable: true,
    get: function () {
      return this.isErrorEnabled_2yzkan$_0;
    }
  });
  KLoggerJS.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'KLoggerJS',
    interfaces: [ActualKLogger]
  };
  function KLoggerNameResolver() {
    KLoggerNameResolver_instance = this;
  }
  KLoggerNameResolver.prototype.name_ls4sck$ = defineInlineFunction('kotlin-logging-js-legacy.io.github.oshai.internal.KLoggerNameResolver.name_ls4sck$', wrapFunction(function () {
    var get_js = Kotlin.kotlin.js.get_js_1yb8b7$;
    return function (func) {
      return get_js(Kotlin.getKClassFromExpression(func)).name;
    };
  }));
  KLoggerNameResolver.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'KLoggerNameResolver',
    interfaces: []
  };
  var KLoggerNameResolver_instance = null;
  function KLoggerNameResolver_getInstance() {
    if (KLoggerNameResolver_instance === null) {
      new KLoggerNameResolver();
    }
    return KLoggerNameResolver_instance;
  }
  var package$io = _.io || (_.io = {});
  var package$github = package$io.github || (package$io.github = {});
  var package$oshai = package$github.oshai || (package$github.oshai = {});
  package$oshai.isEnabledForLevel_zcuw4o$ = isEnabledForLevel;
  package$oshai.ActualKLogger = ActualKLogger;
  Object.defineProperty(package$oshai, 'KMarkerFactory', {
    get: KMarkerFactory_getInstance
  });
  $$importsForInline$$['kotlin-logging-js-legacy'] = _;
  Object.defineProperty(package$oshai, 'KotlinLogging', {
    get: KotlinLogging_getInstance
  });
  Object.defineProperty(Level, 'TRACE', {
    get: Level$TRACE_getInstance
  });
  Object.defineProperty(Level, 'DEBUG', {
    get: Level$DEBUG_getInstance
  });
  Object.defineProperty(Level, 'INFO', {
    get: Level$INFO_getInstance
  });
  Object.defineProperty(Level, 'WARN', {
    get: Level$WARN_getInstance
  });
  Object.defineProperty(Level, 'ERROR', {
    get: Level$ERROR_getInstance
  });
  package$oshai.Level = Level;
  Object.defineProperty(package$oshai, 'Levels', {
    get: Levels_getInstance
  });
  package$oshai.Marker = Marker;
  package$oshai.SimpleMarker = SimpleMarker;
  var package$internal = package$oshai.internal || (package$oshai.internal = {});
  package$internal.toStringSafe_qhgloa$ = toStringSafe;
  Object.defineProperty(package$internal, 'DefaultErrorMessageProducer', {
    get: DefaultErrorMessageProducer_getInstance
  });
  package$oshai.Appender = Appender;
  Object.defineProperty(package$oshai, 'ConsoleOutputAppender', {
    get: ConsoleOutputAppender_getInstance
  });
  Object.defineProperty(package$oshai, 'DefaultMessageFormatter', {
    get: DefaultMessageFormatter_getInstance
  });
  package$oshai.Formatter = Formatter;
  Object.defineProperty(package$oshai, 'KotlinLoggingConfiguration', {
    get: KotlinLoggingConfiguration_getInstance
  });
  package$oshai.isLoggingEnabled_z1pak0$ = isLoggingEnabled;
  Object.defineProperty(package$internal, 'KLoggerFactory', {
    get: KLoggerFactory_getInstance
  });
  package$internal.KLoggerJS = KLoggerJS;
  Object.defineProperty(package$internal, 'KLoggerNameResolver', {
    get: KLoggerNameResolver_getInstance
  });
  Kotlin.defineModule('kotlin-logging-js-legacy', _);
  return _;
}));

//# sourceMappingURL=kotlin-logging-js-legacy.js.map
