/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen;

import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.GeneratedAnnotationResolver;
import com.querydsl.codegen.ProjectionSerializer;
import com.querydsl.codegen.SerializerConfig;
import com.querydsl.codegen.TypeMappings;
import com.querydsl.codegen.utils.CodeWriter;
import com.querydsl.codegen.utils.StringUtils;
import com.querydsl.codegen.utils.model.ClassType;
import com.querydsl.codegen.utils.model.Constructor;
import com.querydsl.codegen.utils.model.Parameter;
import com.querydsl.codegen.utils.model.SimpleType;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.TypeCategory;
import com.querydsl.codegen.utils.model.TypeExtends;
import com.querydsl.codegen.utils.model.Types;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.NumberExpression;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DefaultProjectionSerializer
implements ProjectionSerializer {
    private final Class<? extends Annotation> generatedAnnotationClass;
    private final TypeMappings typeMappings;

    public DefaultProjectionSerializer(TypeMappings typeMappings) {
        this(typeMappings, GeneratedAnnotationResolver.resolveDefault());
    }

    @Inject
    public DefaultProjectionSerializer(TypeMappings typeMappings, @Named(value="generatedAnnotationClass") Class<? extends Annotation> generatedAnnotationClass) {
        this.typeMappings = typeMappings;
        this.generatedAnnotationClass = generatedAnnotationClass;
    }

    private Parameter getExpressionParameter(EntityType model, boolean asExpr, Parameter p) {
        ClassType type = !asExpr ? this.typeMappings.getExprType(p.getType(), model, false, false, true) : new ClassType(Expression.class, new Type[]{p.getType().isFinal() ? p.getType() : new TypeExtends(p.getType())});
        return new Parameter(p.getName(), (Type)type);
    }

    protected void intro(EntityType model, CodeWriter writer) throws IOException {
        String simpleName = model.getSimpleName();
        Type queryType = this.typeMappings.getPathType((Type)model, model, false);
        if (!queryType.getPackageName().isEmpty()) {
            writer.packageDecl(queryType.getPackageName());
        }
        this.imports(model, writer);
        HashSet<Integer> sizes = new HashSet<Integer>();
        ArrayList<Constructor> constructors = new ArrayList<Constructor>(model.getConstructors());
        Collections.sort(constructors);
        for (Constructor c : constructors) {
            sizes.add(c.getParameters().size());
        }
        if (sizes.size() != constructors.size()) {
            writer.imports(new Class[]{Expression.class});
        }
        writer.javadoc(new String[]{String.valueOf(queryType) + " is a Querydsl Projection type for " + simpleName});
        writer.suppressWarnings("this-escape");
        writer.line(new String[]{"@", this.generatedAnnotationClass.getSimpleName(), "(\"", this.getClass().getName(), "\")"});
        ClassType superType = new ClassType(TypeCategory.SIMPLE, ConstructorExpression.class, new Type[]{model});
        writer.beginClass(queryType, (Type)superType, new Type[0]);
        writer.privateStaticFinal((Type)Types.LONG_P, "serialVersionUID", model.hashCode() + "L");
    }

    protected void imports(EntityType model, CodeWriter writer) throws IOException {
        writer.imports(new Package[]{NumberExpression.class.getPackage()});
        writer.imports(new Class[]{ConstructorExpression.class, this.generatedAnnotationClass});
    }

    protected void outro(EntityType model, CodeWriter writer) throws IOException {
        writer.end();
    }

    @Override
    public void serialize(EntityType model, SerializerConfig serializerConfig, CodeWriter writer) throws IOException {
        this.intro(model, writer);
        String localName = writer.getRawName((Type)model);
        HashSet<Integer> sizes = new HashSet<Integer>();
        Type queryType = this.typeMappings.getPathType((Type)model, model, false);
        ArrayList<Constructor> constructors = new ArrayList<Constructor>(model.getConstructors());
        Collections.sort(constructors);
        for (Constructor c : constructors) {
            ArrayList parameters = new ArrayList(c.getParameters());
            boolean asExpr = sizes.add(parameters.size());
            writer.beginConstructor(parameters, parameter -> this.getExpressionParameter(model, asExpr, (Parameter)parameter));
            writer.beginLine(new String[]{"super", "(" + writer.getClassConstant(localName)});
            writer.append((CharSequence)", new Class<?>[]{");
            for (int i = 0; i < parameters.size(); ++i) {
                Parameter p;
                if (i != 0) {
                    writer.append((CharSequence)", ");
                }
                if (Types.PRIMITIVES.containsKey((p = (Parameter)parameters.get(i)).getType())) {
                    Type primitive = (Type)Types.PRIMITIVES.get(p.getType());
                    writer.append((CharSequence)writer.getClassConstant(primitive.getFullName()));
                    continue;
                }
                writer.append((CharSequence)writer.getClassConstant(writer.getRawName(p.getType())));
            }
            writer.append((CharSequence)"}");
            for (Parameter p : c.getParameters()) {
                writer.append((CharSequence)", ");
                this.parameter(writer, p);
            }
            writer.append((CharSequence)");\n");
            writer.end();
        }
        sizes = new HashSet();
        for (Constructor c : model.getConstructors()) {
            this.appendInnerStaticBuilderClass(model, writer, queryType, c, sizes);
            this.appendStaticBuilderFactoryMethod(writer, c);
        }
        this.outro(model, writer);
    }

    protected void parameterType(CodeWriter writer, Parameter p) throws IOException {
        if (Types.PRIMITIVES.containsKey(p.getType())) {
            Type primitive = (Type)Types.PRIMITIVES.get(p.getType());
            writer.append((CharSequence)writer.getClassConstant(primitive.getFullName()));
        } else {
            writer.append((CharSequence)writer.getClassConstant(writer.getRawName(p.getType())));
        }
    }

    protected void parameter(CodeWriter writer, Parameter p) throws IOException {
        writer.append((CharSequence)p.getName());
    }

    private void appendInnerStaticBuilderClass(EntityType model, CodeWriter writer, Type queryType, Constructor constructor, Set<Integer> sizes) throws IOException {
        Parameter expressionParameter;
        if (this.isBuilderDisabled(constructor)) {
            return;
        }
        String builderName = constructor.getBuilderName();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(constructor.getParameters());
        boolean asExpr = sizes.add(parameters.size());
        String builderClassName = StringUtils.capitalize((String)builderName) + "Builder";
        SimpleType builderType = new SimpleType(builderClassName);
        writer.beginInnerStaticClass((Type)builderType);
        for (Parameter param : parameters) {
            expressionParameter = this.getExpressionParameter(model, asExpr, param);
            writer.privateField(expressionParameter.getType(), expressionParameter.getName());
        }
        for (Parameter param : parameters) {
            expressionParameter = this.getExpressionParameter(model, asExpr, param);
            this.appendPublicSetterForBuilder(writer, expressionParameter, (Type)builderType);
        }
        this.appendPublicBuildMethodForBuilder(writer, queryType, parameters);
        writer.end();
    }

    private void appendPublicSetterForBuilder(CodeWriter writer, Parameter expressionParameter, Type builderType) throws IOException {
        writer.beginPublicMethod(builderType, "set" + StringUtils.capitalize((String)expressionParameter.getName()), new Parameter[]{expressionParameter});
        writer.line(new String[]{"this", ".", expressionParameter.getName(), " = ", expressionParameter.getName(), ";"});
        writer.line(new String[]{"return ", "this", ";"});
        writer.end();
    }

    private void appendPublicBuildMethodForBuilder(CodeWriter writer, Type queryType, ArrayList<Parameter> parameters) throws IOException {
        writer.beginPublicMethod(queryType, "build", new Parameter[0]);
        writer.beginLine(new String[]{"return ", "new ", queryType.getSimpleName(), "("});
        for (int i = 0; i < parameters.size(); ++i) {
            if (i != 0) {
                writer.append((CharSequence)", ");
            }
            writer.append((CharSequence)parameters.get(i).getName());
            if (i != parameters.size() - 1) continue;
            writer.append((CharSequence)")").append(";").append("\n");
        }
        writer.end();
    }

    private void appendStaticBuilderFactoryMethod(CodeWriter writer, Constructor constructor) throws IOException {
        if (this.isBuilderDisabled(constructor)) {
            return;
        }
        String builderName = constructor.getBuilderName();
        String builderClassName = StringUtils.capitalize((String)builderName) + "Builder";
        String factoryMethodName = "builder" + StringUtils.capitalize((String)builderName);
        SimpleType builderType = new SimpleType(builderClassName);
        writer.beginStaticMethod((Type)builderType, factoryMethodName, new Parameter[0]);
        writer.line(new String[]{"return ", "new ", builderType.getSimpleName(), "()", ";"});
        writer.end();
    }

    private boolean isBuilderDisabled(Constructor constructor) {
        if (!constructor.useBuilder()) {
            return true;
        }
        return constructor.getBuilderName() == null || constructor.getBuilderName().trim().isEmpty();
    }
}

