/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen.utils;

import com.querydsl.codegen.utils.CodeWriter;
import com.querydsl.codegen.utils.StringUtils;
import java.io.IOException;

public abstract class AbstractCodeWriter<T extends AbstractCodeWriter<T>>
implements Appendable,
CodeWriter {
    private final Appendable appendable;
    private final int spaces;
    private final String spacesString;
    private String indent = "";
    private final T self = this;

    public AbstractCodeWriter(Appendable appendable, int spaces) {
        if (appendable == null) {
            throw new IllegalArgumentException("appendable is null");
        }
        this.appendable = appendable;
        this.spaces = spaces;
        this.spacesString = StringUtils.repeat(' ', spaces);
    }

    public T append(char c) throws IOException {
        this.appendable.append(c);
        return this.self;
    }

    public T append(CharSequence csq) throws IOException {
        this.appendable.append(csq);
        return this.self;
    }

    public T append(CharSequence csq, int start, int end) throws IOException {
        this.appendable.append(csq, start, end);
        return this.self;
    }

    public T beginLine(String ... segments) throws IOException {
        this.append(this.indent);
        for (String segment : segments) {
            this.append(segment);
        }
        return this.self;
    }

    protected T goIn() {
        this.indent = this.indent + this.spacesString;
        return this.self;
    }

    protected T goOut() {
        if (this.indent.length() >= this.spaces) {
            this.indent = this.indent.substring(0, this.indent.length() - this.spaces);
        }
        return this.self;
    }

    public T line(String ... segments) throws IOException {
        this.append(this.indent);
        for (String segment : segments) {
            this.append(segment);
        }
        return (T)this.nl();
    }

    public T nl() throws IOException {
        return (T)this.append("\n");
    }
}

