/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.apt;

import com.querydsl.apt.SimpleTypeVisitorAdapter;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;

class TypeExtractor
extends SimpleTypeVisitorAdapter<TypeElement, Void> {
    private final boolean skipEnum;

    TypeExtractor(boolean skipEnum) {
        this.skipEnum = skipEnum;
    }

    @Override
    public TypeElement visitPrimitive(PrimitiveType t, Void p) {
        return null;
    }

    @Override
    public TypeElement visitNull(NullType t, Void p) {
        return null;
    }

    @Override
    public TypeElement visitArray(ArrayType t, Void p) {
        return (TypeElement)this.visit(t.getComponentType());
    }

    @Override
    public TypeElement visitDeclared(DeclaredType t, Void p) {
        if (t.asElement() instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)t.asElement();
            switch (typeElement.getKind().name()) {
                case "ENUM": {
                    return this.skipEnum ? null : typeElement;
                }
                case "RECORD": 
                case "CLASS": {
                    return typeElement;
                }
                case "INTERFACE": {
                    return this.visitInterface(t);
                }
            }
            throw new IllegalArgumentException("Illegal type: " + typeElement);
        }
        return null;
    }

    private TypeElement visitInterface(DeclaredType t) {
        if (t.getTypeArguments().isEmpty()) {
            return (TypeElement)t.asElement();
        }
        int count = t.getTypeArguments().size();
        if (t.asElement().toString().startsWith("java.util")) {
            return t.getTypeArguments().get(count - 1).accept(this, null);
        }
        return (TypeElement)t.asElement();
    }

    @Override
    public TypeElement visitError(ErrorType t, Void p) {
        return this.visitDeclared((DeclaredType)t, p);
    }

    @Override
    public TypeElement visitTypeVariable(TypeVariable t, Void p) {
        if (t.getUpperBound() != null) {
            return (TypeElement)this.visit(t.getUpperBound());
        }
        if (t.getLowerBound() != null) {
            return (TypeElement)this.visit(t.getLowerBound());
        }
        return null;
    }

    @Override
    public TypeElement visitWildcard(WildcardType t, Void p) {
        if (t.getExtendsBound() != null) {
            return (TypeElement)this.visit(t.getExtendsBound());
        }
        if (t.getSuperBound() != null) {
            return (TypeElement)this.visit(t.getSuperBound());
        }
        return null;
    }

    @Override
    public TypeElement visitExecutable(ExecutableType t, Void p) {
        return null;
    }

    @Override
    public TypeElement visitNoType(NoType t, Void p) {
        return null;
    }
}

