/*
 * Decompiled with CFR 0.152.
 */
package feign.vertx;

import feign.Contract;
import feign.MethodMetadata;
import feign.Types;
import feign.Util;
import io.vertx.core.Future;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public final class VertxDelegatingContract
implements Contract {
    private final Contract delegate;

    public VertxDelegatingContract(Contract delegate) {
        this.delegate = (Contract)Util.checkNotNull((Object)delegate, (String)"delegate must not be null", (Object[])new Object[0]);
    }

    public List<MethodMetadata> parseAndValidateMetadata(Class<?> targetType) {
        Util.checkNotNull(targetType, (String)"Argument targetType must be not null", (Object[])new Object[0]);
        List metadatas = this.delegate.parseAndValidateMetadata(targetType);
        for (MethodMetadata metadata : metadatas) {
            Type type = metadata.returnType();
            if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType().equals(Future.class)) {
                Type actualType = Types.resolveLastTypeParameter((Type)type, Future.class);
                metadata.returnType(actualType);
                continue;
            }
            throw new IllegalStateException(String.format("Method %s of contract %s doesn't returns io.vertx.core.Future", metadata.configKey(), targetType.getSimpleName()));
        }
        return metadatas;
    }
}

