/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.MethodMetadata;
import feign.Param;
import feign.RequestTemplate;
import feign.Util;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class BuildTemplateByResolvingArgs
implements RequestTemplate.Factory {
    final MethodMetadata metadata;
    private final Map<Integer, Param.Expander> indexToExpander = new HashMap<Integer, Param.Expander>();

    BuildTemplateByResolvingArgs(MethodMetadata metadata) {
        this.metadata = metadata;
        if (metadata.indexToExpander() != null) {
            this.indexToExpander.putAll(metadata.indexToExpander());
            return;
        }
        if (metadata.indexToExpanderClass().isEmpty()) {
            return;
        }
        for (Map.Entry indexToExpanderClass : metadata.indexToExpanderClass().entrySet()) {
            try {
                this.indexToExpander.put((Integer)indexToExpanderClass.getKey(), (Param.Expander)((Class)indexToExpanderClass.getValue()).newInstance());
            }
            catch (IllegalAccessException | InstantiationException exception) {
                throw new IllegalStateException(exception);
            }
        }
    }

    public RequestTemplate create(Object[] argv) {
        RequestTemplate mutable = new RequestTemplate(this.metadata.template());
        if (this.metadata.urlIndex() != null) {
            int urlIndex = this.metadata.urlIndex();
            Util.checkNotNull((Object)argv[urlIndex], (String)"URI parameter %s was null", (Object[])new Object[]{urlIndex});
            mutable.insert(0, (CharSequence)String.valueOf(argv[urlIndex]));
        }
        HashMap<String, Object> varBuilder = new HashMap<String, Object>();
        for (Map.Entry entry : this.metadata.indexToName().entrySet()) {
            int i = (Integer)entry.getKey();
            Object value = argv[(Integer)entry.getKey()];
            if (value == null) continue;
            if (this.indexToExpander.containsKey(i)) {
                value = this.indexToExpander.get(i).expand(value);
            }
            for (String name : (Collection)entry.getValue()) {
                varBuilder.put(name, value);
            }
        }
        RequestTemplate template = this.resolve(argv, mutable, varBuilder);
        if (this.metadata.queryMapIndex() != null) {
            template = this.addQueryMapQueryParameters(argv, template);
        }
        if (this.metadata.headerMapIndex() != null) {
            template = this.addHeaderMapHeaders(argv, template);
        }
        return template;
    }

    private RequestTemplate addHeaderMapHeaders(Object[] argv, RequestTemplate mutableRequestTemplate) {
        Map headerMap = (Map)argv[this.metadata.headerMapIndex()];
        for (Map.Entry currEntry : headerMap.entrySet()) {
            Util.checkState((currEntry.getKey().getClass() == String.class ? 1 : 0) != 0, (String)"HeaderMap key must be a String: %s", (Object[])new Object[]{currEntry.getKey()});
            Object currValue = currEntry.getValue();
            ArrayList<String> values = new ArrayList<String>();
            if (currValue instanceof Iterable) {
                for (Object valueObject : (Iterable)currValue) {
                    values.add(valueObject == null ? null : valueObject.toString());
                }
            } else {
                values.add(currValue == null ? null : currValue.toString());
            }
            mutableRequestTemplate.header((String)currEntry.getKey(), values);
        }
        return mutableRequestTemplate;
    }

    private RequestTemplate addQueryMapQueryParameters(Object[] argv, RequestTemplate mutableRequestTemplate) {
        Map queryMap = (Map)argv[this.metadata.queryMapIndex()];
        for (Map.Entry currEntry : queryMap.entrySet()) {
            Util.checkState((currEntry.getKey().getClass() == String.class ? 1 : 0) != 0, (String)"QueryMap key must be a String: %s", (Object[])new Object[]{currEntry.getKey()});
            Object currValue = currEntry.getValue();
            ArrayList<String> values = new ArrayList<String>();
            if (currValue instanceof Iterable) {
                for (Object valueObject : (Iterable)currValue) {
                    values.add(valueObject == null ? null : valueObject.toString());
                }
            } else {
                values.add(currValue == null ? null : currValue.toString());
            }
            mutableRequestTemplate.query((String)currEntry.getKey(), values);
        }
        return mutableRequestTemplate;
    }

    protected RequestTemplate resolve(Object[] argv, RequestTemplate mutable, Map<String, Object> variables) {
        return mutable.resolve(variables);
    }

    static final class BuildEncodedTemplateFromArgs
    extends BuildTemplateByResolvingArgs {
        private final Encoder encoder;

        BuildEncodedTemplateFromArgs(MethodMetadata metadata, Encoder encoder) {
            super(metadata);
            this.encoder = encoder;
        }

        @Override
        protected RequestTemplate resolve(Object[] argv, RequestTemplate mutable, Map<String, Object> variables) {
            Object body = argv[this.metadata.bodyIndex()];
            Util.checkNotNull((Object)body, (String)"Body parameter %s was null", (Object[])new Object[]{this.metadata.bodyIndex()});
            try {
                this.encoder.encode(body, this.metadata.bodyType(), mutable);
            }
            catch (EncodeException encodeException) {
                throw encodeException;
            }
            catch (RuntimeException unexpectedException) {
                throw new EncodeException(unexpectedException.getMessage(), (Throwable)unexpectedException);
            }
            return super.resolve(argv, mutable, variables);
        }
    }

    static final class BuildFormEncodedTemplateFromArgs
    extends BuildTemplateByResolvingArgs {
        private final Encoder encoder;

        BuildFormEncodedTemplateFromArgs(MethodMetadata metadata, Encoder encoder) {
            super(metadata);
            this.encoder = encoder;
        }

        @Override
        protected RequestTemplate resolve(Object[] argv, RequestTemplate mutable, Map<String, Object> variables) {
            HashMap<String, Object> formVariables = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : variables.entrySet()) {
                if (!this.metadata.formParams().contains(entry.getKey())) continue;
                formVariables.put(entry.getKey(), entry.getValue());
            }
            try {
                this.encoder.encode(formVariables, Encoder.MAP_STRING_WILDCARD, mutable);
            }
            catch (EncodeException encodeException) {
                throw encodeException;
            }
            catch (RuntimeException unexpectedException) {
                throw new EncodeException(unexpectedException.getMessage(), (Throwable)unexpectedException);
            }
            return super.resolve(argv, mutable, variables);
        }
    }
}

