/*
 * Decompiled with CFR 0.152.
 */
package feign.spring;

import feign.DeclarativeContract;
import feign.MethodMetadata;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public class SpringContract
extends DeclarativeContract {
    static final String ACCEPT = "Accept";
    static final String CONTENT_TYPE = "Content-Type";

    public SpringContract() {
        this.registerClassAnnotation(RequestMapping.class, (requestMapping, data) -> {
            this.appendMappings(data, requestMapping.value());
            if (requestMapping.method().length == 1) {
                data.template().method(requestMapping.method()[0].name());
            }
            this.handleProducesAnnotation(data, requestMapping.produces());
            this.handleConsumesAnnotation(data, requestMapping.consumes());
        });
        this.registerMethodAnnotation(RequestMapping.class, (requestMapping, data) -> {
            String[] mappings = requestMapping.value();
            this.appendMappings(data, mappings);
            if (requestMapping.method().length == 1) {
                data.template().method(requestMapping.method()[0].name());
            }
        });
        this.registerMethodAnnotation(ResponseBody.class, (body, data) -> this.handleConsumesAnnotation(data, "application/json"));
        this.registerMethodAnnotation(ExceptionHandler.class, (ann, data) -> data.ignoreMethod());
        this.registerParameterAnnotation(PathVariable.class, (parameterAnnotation, data, paramIndex) -> {
            String name = ((PathVariable)PathVariable.class.cast(parameterAnnotation)).value();
            this.nameParam(data, name, paramIndex);
        });
        this.registerParameterAnnotation(RequestBody.class, (body, data, paramIndex) -> this.handleProducesAnnotation(data, "application/json"));
        this.registerParameterAnnotation(RequestParam.class, (parameterAnnotation, data, paramIndex) -> {
            String name = ((RequestParam)RequestParam.class.cast(parameterAnnotation)).value();
            Collection<String> query = this.addTemplatedParam((Collection)data.template().queries().get(name), name);
            data.template().query(name, query);
            this.nameParam(data, name, paramIndex);
        });
    }

    private void appendMappings(MethodMetadata data, String[] mappings) {
        for (int i = 0; i < mappings.length; ++i) {
            String methodAnnotationValue = mappings[i];
            if (!methodAnnotationValue.startsWith("/") && !data.template().url().endsWith("/")) {
                methodAnnotationValue = "/" + methodAnnotationValue;
            }
            if (data.template().url().endsWith("/") && methodAnnotationValue.startsWith("/")) {
                methodAnnotationValue = methodAnnotationValue.substring(1);
            }
            data.template().uri(data.template().url() + methodAnnotationValue);
        }
    }

    private void handleProducesAnnotation(MethodMetadata data, String ... produces) {
        if (produces.length == 0) {
            return;
        }
        data.template().removeHeader(ACCEPT);
        data.template().header(ACCEPT, new String[]{produces[0]});
    }

    private void handleConsumesAnnotation(MethodMetadata data, String ... consumes) {
        if (consumes.length == 0) {
            return;
        }
        data.template().removeHeader(CONTENT_TYPE);
        data.template().header(CONTENT_TYPE, new String[]{consumes[0]});
    }

    protected Collection<String> addTemplatedParam(Collection<String> possiblyNull, String name) {
        if (possiblyNull == null) {
            possiblyNull = new ArrayList<String>();
        }
        possiblyNull.add(String.format("{%s}", name));
        return possiblyNull;
    }
}

