/*
 * Decompiled with CFR 0.152.
 */
package feign.mock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RequestHeaders {
    public static final Map<String, Collection<String>> EMPTY = Collections.emptyMap();
    private Map<String, Collection<String>> headers;

    public static Builder builder() {
        return new Builder();
    }

    public static RequestHeaders of(Map<String, Collection<String>> headers) {
        return new RequestHeaders(headers);
    }

    private RequestHeaders(Builder builder) {
        this.headers = builder.headers;
    }

    private RequestHeaders(Map<String, Collection<String>> headers) {
        this.headers = headers;
    }

    public int size() {
        return this.headers.size();
    }

    public int sizeOf(String key) {
        if (!this.headers.containsKey(key)) {
            return 0;
        }
        return this.headers.get(key).size();
    }

    public Collection<String> fetch(String key) {
        return this.headers.get(key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestHeaders other = (RequestHeaders)obj;
        return this.headers.equals(other.headers);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Collection<String>> entry : this.headers.entrySet()) {
            builder.append(entry).append(',').append(' ');
        }
        if (builder.length() > 0) {
            return builder.substring(0, builder.length() - 2);
        }
        return "no";
    }

    /* synthetic */ RequestHeaders(Builder builder, RequestHeaders requestHeaders) {
        this(builder);
    }

    public static class Builder {
        private Map<String, Collection<String>> headers = new HashMap<String, Collection<String>>();

        private Builder() {
        }

        public Builder add(String key, Collection<String> values) {
            if (!this.headers.containsKey(key)) {
                this.headers.put(key, values);
            } else {
                Collection<String> previousValues = this.headers.get(key);
                previousValues.addAll(values);
                this.headers.put(key, previousValues);
            }
            return this;
        }

        public Builder add(String key, String value) {
            if (!this.headers.containsKey(key)) {
                this.headers.put(key, new ArrayList<String>(Arrays.asList(value)));
            } else {
                Collection<String> values = this.headers.get(key);
                values.add(value);
                this.headers.put(key, values);
            }
            return this;
        }

        public RequestHeaders build() {
            return new RequestHeaders(this, null);
        }
    }
}

