/*
 * Decompiled with CFR 0.152.
 */
package feign.micrometer;

import feign.AsyncClient;
import feign.Capability;
import feign.Client;
import feign.FeignException;
import feign.Request;
import feign.Response;
import feign.micrometer.DefaultFeignObservationConvention;
import feign.micrometer.FeignContext;
import feign.micrometer.FeignObservationConvention;
import feign.micrometer.FeignObservationDocumentation;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;

public class MicrometerObservationCapability
implements Capability {
    private final ObservationRegistry observationRegistry;
    private final FeignObservationConvention customFeignObservationConvention;

    public MicrometerObservationCapability(ObservationRegistry observationRegistry, FeignObservationConvention customFeignObservationConvention) {
        this.observationRegistry = observationRegistry;
        this.customFeignObservationConvention = customFeignObservationConvention;
    }

    public MicrometerObservationCapability(ObservationRegistry observationRegistry) {
        this(observationRegistry, null);
    }

    public Client enrich(Client client) {
        return (request, options) -> {
            FeignContext feignContext = new FeignContext(request);
            Observation observation = FeignObservationDocumentation.DEFAULT.observation(this.customFeignObservationConvention, DefaultFeignObservationConvention.INSTANCE, () -> feignContext, this.observationRegistry).start();
            try {
                Response response = client.execute(request, options);
                this.finalizeObservation(feignContext, observation, null, response);
                return response;
            }
            catch (FeignException ex) {
                this.finalizeObservation(feignContext, observation, ex, null);
                throw ex;
            }
        };
    }

    public AsyncClient<Object> enrich(AsyncClient<Object> client) {
        return (request, options, context) -> {
            FeignContext feignContext = new FeignContext(request);
            Observation observation = FeignObservationDocumentation.DEFAULT.observation(this.customFeignObservationConvention, DefaultFeignObservationConvention.INSTANCE, () -> feignContext, this.observationRegistry).start();
            try {
                return client.execute((Request)feignContext.getCarrier(), options, context).whenComplete((r, ex) -> this.finalizeObservation(feignContext, observation, (Throwable)ex, (Response)r));
            }
            catch (FeignException ex2) {
                this.finalizeObservation(feignContext, observation, ex2, null);
                throw ex2;
            }
        };
    }

    private void finalizeObservation(FeignContext feignContext, Observation observation, Throwable ex, Response response) {
        feignContext.setResponse(response);
        if (ex != null) {
            observation.error(ex);
        }
        observation.stop();
    }
}

