/*
 * Decompiled with CFR 0.152.
 */
package feign.micrometer;

import feign.Feign;
import feign.FeignException;
import feign.InvocationHandlerFactory;
import feign.Target;
import feign.Util;
import feign.micrometer.FeignMetricName;
import feign.micrometer.FeignMetricTagResolver;
import feign.micrometer.MetricName;
import feign.micrometer.MetricTagResolver;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MeteredInvocationHandleFactory
implements InvocationHandlerFactory {
    private static final List<String> JAVA_OBJECT_METHODS = Arrays.asList("equals", "toString", "hashCode");
    private final InvocationHandlerFactory invocationHandler;
    private final MeterRegistry meterRegistry;
    private final MetricName metricName;
    private final MetricTagResolver metricTagResolver;

    public MeteredInvocationHandleFactory(InvocationHandlerFactory invocationHandler, MeterRegistry meterRegistry) {
        this(invocationHandler, meterRegistry, new FeignMetricName(Feign.class), new FeignMetricTagResolver());
    }

    public MeteredInvocationHandleFactory(InvocationHandlerFactory invocationHandler, MeterRegistry meterRegistry, MetricName metricName, MetricTagResolver metricTagResolver) {
        this.invocationHandler = invocationHandler;
        this.meterRegistry = meterRegistry;
        this.metricName = metricName;
        this.metricTagResolver = metricTagResolver;
    }

    public InvocationHandler create(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        InvocationHandler invocationHandle = this.invocationHandler.create(target, dispatch);
        return (proxy, method, args) -> {
            Object object;
            if (JAVA_OBJECT_METHODS.contains(method.getName()) || Util.isDefault((Method)method)) {
                return invocationHandle.invoke(proxy, method, args);
            }
            Timer.Sample sample = Timer.start((MeterRegistry)this.meterRegistry);
            Timer timer = null;
            try {
                Object invoke = invocationHandle.invoke(proxy, method, args);
                timer = this.createTimer(target, method, args, null);
                object = invoke;
                if (timer == null) {
                    timer = this.createTimer(target, method, args, null);
                }
            }
            catch (Exception e) {
                try {
                    try {
                        throw e;
                        catch (Throwable e2) {
                            throw new Exception(e2);
                        }
                    }
                    catch (FeignException e3) {
                        timer = this.createTimer(target, method, args, e3);
                        this.createFeignExceptionCounter(target, method, args, e3).increment();
                        throw e3;
                    }
                    catch (Throwable e4) {
                        timer = this.createTimer(target, method, args, e4);
                        this.createExceptionCounter(target, method, args, e4).increment();
                        throw e4;
                    }
                }
                catch (Throwable throwable) {
                    if (timer == null) {
                        timer = this.createTimer(target, method, args, null);
                    }
                    sample.stop(timer);
                    throw throwable;
                }
            }
            sample.stop(timer);
            return object;
        };
    }

    protected Timer createTimer(Target target, Method method, Object[] args, Throwable e) {
        Tag[] extraTags = this.extraTags(target, method, args, e);
        Tags allTags = this.metricTagResolver.tag(target.type(), method, target.url(), e, extraTags);
        return this.meterRegistry.timer(this.metricName.name(e), (Iterable)allTags);
    }

    protected Counter createExceptionCounter(Target target, Method method, Object[] args, Throwable e) {
        Tag[] extraTags = this.extraTags(target, method, args, e);
        Tags allTags = this.metricTagResolver.tag(target.type(), method, target.url(), e, extraTags);
        return this.meterRegistry.counter(this.metricName.name(e), (Iterable)allTags);
    }

    protected Counter createFeignExceptionCounter(Target target, Method method, Object[] args, FeignException e) {
        Tag[] extraTags = this.extraTags(target, method, args, e);
        Tags allTags = this.metricTagResolver.tag(target.type(), method, target.url(), e, extraTags).and(new Tag[]{Tag.of((String)"http_status", (String)String.valueOf(e.status())), Tag.of((String)"error_group", (String)(e.status() / 100 + "xx"))});
        return this.meterRegistry.counter(this.metricName.name("http_error"), (Iterable)allTags);
    }

    protected Tag[] extraTags(Target target, Method method, Object[] args, Throwable throwable) {
        return MetricTagResolver.EMPTY_TAGS_ARRAY;
    }
}

