/*
 * Decompiled with CFR 0.152.
 */
package feign.micrometer;

import feign.Feign;
import feign.FeignException;
import feign.InvocationHandlerFactory;
import feign.Target;
import feign.Util;
import feign.micrometer.FeignMetricName;
import feign.micrometer.MetricName;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MeteredInvocationHandleFactory
implements InvocationHandlerFactory {
    private static final List<String> JAVA_OBJECT_METHODS = Arrays.asList("equals", "toString", "hashCode");
    private final InvocationHandlerFactory invocationHandler;
    private final MeterRegistry meterRegistry;
    private final MetricName metricName;

    public MeteredInvocationHandleFactory(InvocationHandlerFactory invocationHandler, MeterRegistry meterRegistry) {
        this(invocationHandler, meterRegistry, new FeignMetricName(Feign.class));
    }

    public MeteredInvocationHandleFactory(InvocationHandlerFactory invocationHandler, MeterRegistry meterRegistry, MetricName metricName) {
        this.invocationHandler = invocationHandler;
        this.meterRegistry = meterRegistry;
        this.metricName = metricName;
    }

    public InvocationHandler create(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        Class clientClass = target.type();
        InvocationHandler invocationHandle = this.invocationHandler.create(target, dispatch);
        return (proxy, method, args) -> {
            if (JAVA_OBJECT_METHODS.contains(method.getName()) || Util.isDefault((Method)method)) {
                return invocationHandle.invoke(proxy, method, args);
            }
            try {
                return this.meterRegistry.timer(this.metricName.name(), (Iterable)this.metricName.tag(clientClass, method, target.url(), new Tag[0])).recordCallable(() -> {
                    try {
                        return invocationHandle.invoke(proxy, method, args);
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new Exception(e);
                    }
                });
            }
            catch (FeignException e) {
                this.meterRegistry.counter(this.metricName.name("http_error"), (Iterable)this.metricName.tag(clientClass, method, target.url(), Tag.of((String)"http_status", (String)String.valueOf(e.status())), Tag.of((String)"error_group", (String)(e.status() / 100 + "xx")))).increment();
                throw e;
            }
            catch (Throwable e) {
                this.meterRegistry.counter(this.metricName.name("exception"), (Iterable)this.metricName.tag(clientClass, method, target.url(), Tag.of((String)"exception_name", (String)e.getClass().getSimpleName()))).increment();
                throw e;
            }
        };
    }
}

