/*
 * Decompiled with CFR 0.152.
 */
package feign.micrometer;

import feign.Client;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import feign.micrometer.FeignMetricName;
import feign.micrometer.MetricName;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.IOException;

public class MeteredClient
implements Client {
    private final Client client;
    private final MeterRegistry meterRegistry;
    private final MetricName metricName;

    public MeteredClient(Client client, MeterRegistry meterRegistry) {
        this(client, meterRegistry, new FeignMetricName(Client.class));
    }

    public MeteredClient(Client client, MeterRegistry meterRegistry, MetricName metricName) {
        this.client = client;
        this.meterRegistry = meterRegistry;
        this.metricName = metricName;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        RequestTemplate template = request.requestTemplate();
        try {
            return (Response)this.meterRegistry.timer(this.metricName.name(), (Iterable)this.metricName.tag(template.methodMetadata(), template.feignTarget(), new Tag[0])).recordCallable(() -> this.client.execute(request, options));
        }
        catch (IOException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

