/*
 * Decompiled with CFR 0.152.
 */
package feign.micrometer;

import feign.MethodMetadata;
import feign.Target;
import feign.micrometer.MetricName;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;

public final class FeignMetricName
implements MetricName {
    private final Class<?> meteredComponent;

    public FeignMetricName(Class<?> meteredComponent) {
        this.meteredComponent = meteredComponent;
    }

    @Override
    public String name(String suffix) {
        return this.name() + "." + suffix;
    }

    @Override
    public String name() {
        return this.meteredComponent.getName();
    }

    @Override
    public Tags tag(MethodMetadata methodMetadata, Target<?> target, Tag ... tags) {
        return this.tag(methodMetadata.targetType(), methodMetadata.method(), target.url(), tags);
    }

    @Override
    public Tags tag(Class<?> targetType, Method method, String url, Tag ... extraTags) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(Tag.of((String)"client", (String)targetType.getName()));
        tags.add(Tag.of((String)"method", (String)method.getName()));
        tags.add(Tag.of((String)"host", (String)this.extractHost(url)));
        tags.addAll(Arrays.asList(extraTags));
        return Tags.of(tags);
    }

    private String extractHost(String targetUrl) {
        try {
            String host = new URI(targetUrl).getHost();
            if (host != null) {
                return host;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return targetUrl.length() <= 20 ? targetUrl : targetUrl.substring(0, 20);
    }
}

