/*
 * Decompiled with CFR 0.152.
 */
package feign.form.util;

import feign.form.FormProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.rmi.UnexpectedException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public final class PojoUtil {
    public static boolean isUserPojo(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        Class<?> type = object.getClass();
        String packageName = type.getPackage().getName();
        return !packageName.startsWith("java.");
    }

    public static boolean isUserPojo(@NonNull Type type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        String typeName = type.toString();
        return !typeName.startsWith("class java.");
    }

    public static Map<String, Object> toMap(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Class<?> type = object.getClass();
        for (Field field : type.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers)) continue;
            field.setAccessible(true);
            Object fieldValue = field.get(object);
            if (fieldValue == null) continue;
            String propertyKey = field.isAnnotationPresent(FormProperty.class) ? field.getAnnotation(FormProperty.class).value() : field.getName();
            result.put(propertyKey, fieldValue);
        }
        return result;
    }

    private PojoUtil() throws UnexpectedException {
        throw new UnexpectedException("It is not allowed to instantiate this class");
    }

    private static final class SetAccessibleAction
    implements PrivilegedAction<Object> {
        private Field field;

        @Override
        public Object run() {
            this.field.setAccessible(true);
            return null;
        }

        @Generated
        public void setField(Field field) {
            this.field = field;
        }

        @Generated
        public SetAccessibleAction() {
        }
    }
}

