/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.FeignException;
import feign.InvocationContext;
import feign.Logger;
import feign.Response;
import feign.ResponseInterceptor;
import feign.Util;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.lang.reflect.Type;

public class ResponseHandler {
    private static final long MAX_RESPONSE_BUFFER_SIZE = 8192L;
    private final Logger.Level logLevel;
    private final Logger logger;
    private final Decoder decoder;
    private final ErrorDecoder errorDecoder;
    private final boolean dismiss404;
    private final boolean closeAfterDecode;
    private final boolean decodeVoid;
    private final ResponseInterceptor responseInterceptor;

    public ResponseHandler(Logger.Level logLevel, Logger logger, Decoder decoder, ErrorDecoder errorDecoder, boolean dismiss404, boolean closeAfterDecode, boolean decodeVoid, ResponseInterceptor responseInterceptor) {
        this.logLevel = logLevel;
        this.logger = logger;
        this.decoder = decoder;
        this.errorDecoder = errorDecoder;
        this.dismiss404 = dismiss404;
        this.closeAfterDecode = closeAfterDecode;
        this.responseInterceptor = responseInterceptor;
        this.decodeVoid = decodeVoid;
    }

    public Object handleResponse(String configKey, Response response, Type returnType, long elapsedTime) throws Exception {
        try {
            boolean shouldDecodeResponseBody;
            response = this.logAndRebufferResponseIfNeeded(configKey, response, elapsedTime);
            if (returnType == Response.class) {
                return ResponseHandler.disconnectResponseBodyIfNeeded(response);
            }
            boolean bl = shouldDecodeResponseBody = response.status() >= 200 && response.status() < 300 || response.status() == 404 && this.dismiss404 && !this.isVoidType(returnType);
            if (!shouldDecodeResponseBody) {
                throw this.decodeError(configKey, response);
            }
            return this.decode(response, returnType);
        }
        catch (IOException e) {
            if (this.logLevel != Logger.Level.NONE) {
                this.logger.logIOException(configKey, this.logLevel, e, elapsedTime);
            }
            throw FeignException.errorReading(response.request(), response, e);
        }
    }

    private boolean isVoidType(Type returnType) {
        return returnType == Void.class || returnType == Void.TYPE || returnType.getTypeName().equals("kotlin.Unit");
    }

    private Response logAndRebufferResponseIfNeeded(String configKey, Response response, long elapsedTime) throws IOException {
        if (this.logLevel == Logger.Level.NONE) {
            return response;
        }
        return this.logger.logAndRebufferResponse(configKey, this.logLevel, response, elapsedTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Response disconnectResponseBodyIfNeeded(Response response) throws IOException {
        boolean shouldDisconnectResponseBody;
        boolean bl = shouldDisconnectResponseBody = response.body() != null && response.body().length() != null && (long)response.body().length().intValue() <= 8192L;
        if (!shouldDisconnectResponseBody) {
            return response;
        }
        try {
            byte[] bodyData = Util.toByteArray(response.body().asInputStream());
            Response response2 = response.toBuilder().body(bodyData).build();
            return response2;
        }
        finally {
            Util.ensureClosed(response.body());
        }
    }

    private Object decode(Response response, Type type) throws IOException {
        if (this.isVoidType(type) && !this.decodeVoid) {
            Util.ensureClosed(response.body());
            return null;
        }
        try {
            Object result = this.responseInterceptor.aroundDecode(new InvocationContext(this.decoder, type, response));
            if (this.closeAfterDecode) {
                Util.ensureClosed(response.body());
            }
            return result;
        }
        catch (Exception e) {
            Util.ensureClosed(response.body());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception decodeError(String methodKey, Response response) {
        try {
            Exception exception = this.errorDecoder.decode(methodKey, response);
            return exception;
        }
        finally {
            Util.ensureClosed(response.body());
        }
    }
}

