/*
 * Decompiled with CFR 0.152.
 */
package example.wikipedia;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import example.wikipedia.ResponseAdapter;
import feign.Feign;
import feign.Logger;
import feign.Param;
import feign.Request;
import feign.RequestLine;
import feign.gson.GsonDecoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class WikipediaExample {
    static ResponseAdapter<Page> pagesAdapter = new ResponseAdapter<Page>(){

        @Override
        protected String query() {
            return "pages";
        }

        @Override
        protected Page build(JsonReader reader) throws IOException {
            Page page = new Page();
            while (reader.hasNext()) {
                String key = reader.nextName();
                if (key.equals("pageid")) {
                    page.id = reader.nextLong();
                    continue;
                }
                if (key.equals("title")) {
                    page.title = reader.nextString();
                    continue;
                }
                reader.skipValue();
            }
            return page;
        }
    };

    public static void main(String ... args) throws InterruptedException {
        Gson gson = new GsonBuilder().registerTypeAdapter(new TypeToken<Response<Page>>(){}.getType(), pagesAdapter).create();
        Wikipedia wikipedia = Feign.builder().decoder(new GsonDecoder(gson)).logger(new Logger.ErrorLogger()).logLevel(Logger.Level.BASIC).options(new Request.Options(10L, TimeUnit.SECONDS, 60L, TimeUnit.SECONDS, true)).target(Wikipedia.class, "https://en.wikipedia.org");
        System.out.println("Let's search for PTAL!");
        Iterator<Page> pages = WikipediaExample.lazySearch(wikipedia, "PTAL");
        while (pages.hasNext()) {
            System.out.println(pages.next().title);
        }
    }

    static Iterator<Page> lazySearch(final Wikipedia wikipedia, final String query) {
        final Response<Page> first = wikipedia.search(query);
        if (first.nextOffset == null) {
            return first.iterator();
        }
        return new Iterator<Page>(){
            Iterator<Page> current;
            Long nextOffset;
            {
                this.current = first.iterator();
                this.nextOffset = first.nextOffset;
            }

            @Override
            public boolean hasNext() {
                while (!this.current.hasNext() && this.nextOffset != null) {
                    System.out.println("Wow.. even more results than " + this.nextOffset);
                    Response<Page> nextPage = wikipedia.resumeSearch(query, this.nextOffset);
                    this.current = nextPage.iterator();
                    this.nextOffset = nextPage.nextOffset;
                }
                return this.current.hasNext();
            }

            @Override
            public Page next() {
                return this.current.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static class Response<X>
    extends ArrayList<X> {
        Long nextOffset;
    }

    static class Page {
        long id;
        String title;

        Page() {
        }
    }

    public static interface Wikipedia {
        @RequestLine(value="GET /w/api.php?action=query&continue=&generator=search&prop=info&format=json&gsrsearch={search}")
        public Response<Page> search(@Param(value="search") String var1);

        @RequestLine(value="GET /w/api.php?action=query&continue=&generator=search&prop=info&format=json&gsrsearch={search}&gsroffset={offset}")
        public Response<Page> resumeSearch(@Param(value="search") String var1, @Param(value="offset") long var2);
    }
}

