/*
 * Decompiled with CFR 0.152.
 */
package example.wikipedia;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import example.wikipedia.ResponseAdapter;
import example.wikipedia.WikipediaClient;
import feign.codec.Decoder;
import feign.gson.GsonDecoder;
import java.io.IOException;
import org.springframework.context.annotation.Bean;

public class WikipediaClientConfiguration {
    static ResponseAdapter<WikipediaClient.Page> pagesAdapter = new ResponseAdapter<WikipediaClient.Page>(){

        @Override
        protected String query() {
            return "pages";
        }

        @Override
        protected WikipediaClient.Page build(JsonReader reader) throws IOException {
            WikipediaClient.Page page = new WikipediaClient.Page();
            while (reader.hasNext()) {
                String key = reader.nextName();
                if (key.equals("pageid")) {
                    page.id = reader.nextLong();
                    continue;
                }
                if (key.equals("title")) {
                    page.title = reader.nextString();
                    continue;
                }
                reader.skipValue();
            }
            return page;
        }
    };

    @Bean
    public Decoder decoder() {
        Gson gson = new GsonBuilder().registerTypeAdapter(new TypeToken<WikipediaClient.Response<WikipediaClient.Page>>(){}.getType(), pagesAdapter).create();
        return new GsonDecoder(gson);
    }
}

