/*
 * Decompiled with CFR 0.152.
 */
package feign.metrics4;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import feign.FeignException;
import feign.RequestTemplate;
import feign.Response;
import feign.metrics4.FeignMetricName;
import feign.metrics4.MetricSuppliers;
import feign.utils.ExceptionUtils;

class BaseMeteredClient {
    protected final MetricRegistry metricRegistry;
    protected final FeignMetricName metricName;
    protected final MetricSuppliers metricSuppliers;

    public BaseMeteredClient(MetricRegistry metricRegistry, FeignMetricName metricName, MetricSuppliers metricSuppliers) {
        this.metricRegistry = metricRegistry;
        this.metricName = metricName;
        this.metricSuppliers = metricSuppliers;
    }

    protected Timer.Context createTimer(RequestTemplate template) {
        return this.metricRegistry.timer(MetricRegistry.name((String)this.metricName.metricName(template.methodMetadata(), template.feignTarget()), (String[])new String[]{"uri", template.methodMetadata().template().path()}), this.metricSuppliers.timers()).time();
    }

    protected void recordSuccess(RequestTemplate template, Response response) {
        this.metricRegistry.meter(MetricRegistry.name((String)this.httpResponseCode(template), (String[])new String[]{"status_group", response.status() / 100 + "xx", "http_status", String.valueOf(response.status()), "http_method", template.methodMetadata().template().method(), "uri", template.methodMetadata().template().path()}), this.metricSuppliers.meters()).mark();
    }

    protected void recordFailure(RequestTemplate template, FeignException e) {
        this.metricRegistry.meter(MetricRegistry.name((String)this.httpResponseCode(template), (String[])new String[]{"exception_name", ((Object)((Object)e)).getClass().getSimpleName(), "root_cause_name", ExceptionUtils.getRootCause((Throwable)e).getClass().getSimpleName(), "status_group", e.status() / 100 + "xx", "http_status", String.valueOf(e.status()), "http_method", template.methodMetadata().template().method(), "uri", template.methodMetadata().template().path()}), this.metricSuppliers.meters()).mark();
    }

    protected void recordFailure(RequestTemplate template, Exception e) {
        this.metricRegistry.meter(MetricRegistry.name((String)this.httpResponseCode(template), (String[])new String[]{"exception_name", e.getClass().getSimpleName(), "root_cause_name", ExceptionUtils.getRootCause((Throwable)e).getClass().getSimpleName(), "uri", template.methodMetadata().template().path()}), this.metricSuppliers.meters()).mark();
    }

    private String httpResponseCode(RequestTemplate template) {
        return this.metricName.metricName(template.methodMetadata(), template.feignTarget(), "http_response_code");
    }
}

