/*
 * Decompiled with CFR 0.152.
 */
package feign.metrics4;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import feign.Feign;
import feign.FeignException;
import feign.InvocationHandlerFactory;
import feign.Target;
import feign.Util;
import feign.metrics4.FeignMetricName;
import feign.metrics4.MetricSuppliers;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeteredInvocationHandleFactory
implements InvocationHandlerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MeteredInvocationHandleFactory.class);
    private static final List<String> JAVA_OBJECT_METHODS = Arrays.asList("equals", "toString", "hashCode");
    private final InvocationHandlerFactory invocationHandler;
    private final MetricRegistry metricRegistry;
    private final FeignMetricName metricName;
    private final MetricSuppliers metricSuppliers;

    public MeteredInvocationHandleFactory(InvocationHandlerFactory invocationHandler, MetricRegistry metricRegistry, MetricSuppliers metricSuppliers) {
        this.invocationHandler = invocationHandler;
        this.metricRegistry = metricRegistry;
        this.metricSuppliers = metricSuppliers;
        this.metricName = new FeignMetricName(Feign.class);
    }

    public InvocationHandler create(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        Class clientClass = target.type();
        InvocationHandler invocationHandle = this.invocationHandler.create(target, dispatch);
        return (proxy, method, args) -> {
            if (JAVA_OBJECT_METHODS.contains(method.getName()) || Util.isDefault((Method)method)) {
                LOG.trace("Skipping metrics for method={}", (Object)method);
                return invocationHandle.invoke(proxy, method, args);
            }
            try (Timer.Context classTimer = this.metricRegistry.timer(this.metricName.metricName(clientClass, method, target.url()), this.metricSuppliers.timers()).time();){
                Object object = invocationHandle.invoke(proxy, method, args);
                return object;
            }
            catch (FeignException e) {
                this.metricRegistry.meter(MetricRegistry.name((String)this.metricName.metricName(clientClass, method, target.url()), (String[])new String[]{"http_error", e.status() / 100 + "xx", String.valueOf(e.status())}), this.metricSuppliers.meters()).mark();
                throw e;
            }
            catch (Throwable e) {
                this.metricRegistry.meter(MetricRegistry.name((String)this.metricName.metricName(clientClass, method, target.url()), (String[])new String[]{"exception", e.getClass().getSimpleName()}), this.metricSuppliers.meters()).mark();
                throw e;
            }
        };
    }
}

