/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.spectator.tcp;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import io.reactivex.netty.protocol.tcp.client.events.TcpClientEventListener;
import io.reactivex.netty.spectator.internal.EventMetric;
import io.reactivex.netty.spectator.internal.SpectatorUtils;
import java.util.concurrent.TimeUnit;

public class TcpClientListener
extends TcpClientEventListener {
    private final EventMetric connection;
    private final EventMetric connectionClose;
    private final EventMetric poolAcquire;
    private final EventMetric poolRelease;
    private final Counter poolEvictions;
    private final Counter poolReuse;
    private final EventMetric write;
    private final EventMetric flush;
    private final Counter bytesRead;
    private final Counter bytesWritten;

    public TcpClientListener(Registry registry, String monitorId) {
        this.connection = new EventMetric(registry, "connection", monitorId, "action", "connect");
        this.connectionClose = new EventMetric(registry, "connection", monitorId, "action", "handle");
        this.poolAcquire = new EventMetric(registry, "connection.pool", monitorId, "action", "acquire");
        this.poolRelease = new EventMetric(registry, "connection.pool", monitorId, "action", "release");
        this.poolEvictions = SpectatorUtils.newCounter(registry, "connection.pool", monitorId, "action", "evict");
        this.poolReuse = SpectatorUtils.newCounter(registry, "connection.pool", monitorId, "action", "reuse");
        this.write = new EventMetric(registry, "writes", monitorId, "action", "write");
        this.flush = new EventMetric(registry, "writes", monitorId, "action", "flush");
        this.bytesWritten = SpectatorUtils.newCounter(registry, "bytes", monitorId, "rtype", "count", "action", "write");
        this.bytesRead = SpectatorUtils.newCounter(registry, "bytes", monitorId, "rtype", "count", "action", "read");
    }

    public TcpClientListener(String monitorId) {
        this(Spectator.globalRegistry(), monitorId);
    }

    @Override
    public void onByteRead(long bytesRead) {
        this.bytesRead.increment(bytesRead);
    }

    @Override
    public void onByteWritten(long bytesWritten) {
        this.bytesWritten.increment(bytesWritten);
    }

    @Override
    public void onFlushComplete(long duration, TimeUnit timeUnit) {
        this.flush.success(duration, timeUnit);
    }

    @Override
    public void onFlushStart() {
        this.flush.start();
    }

    @Override
    public void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.write.failure(duration, timeUnit);
    }

    @Override
    public void onWriteSuccess(long duration, TimeUnit timeUnit) {
        this.write.success(duration, timeUnit);
    }

    @Override
    public void onWriteStart() {
        this.write.start();
    }

    @Override
    public void onPoolReleaseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.poolRelease.failure(duration, timeUnit);
    }

    @Override
    public void onPoolReleaseSuccess(long duration, TimeUnit timeUnit) {
        this.poolRelease.success(duration, timeUnit);
    }

    @Override
    public void onPoolReleaseStart() {
        this.poolRelease.start();
    }

    @Override
    public void onPooledConnectionEviction() {
        this.poolEvictions.increment();
    }

    @Override
    public void onPooledConnectionReuse() {
        this.poolReuse.increment();
    }

    @Override
    public void onPoolAcquireFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.poolAcquire.failure(duration, timeUnit);
    }

    @Override
    public void onPoolAcquireSuccess(long duration, TimeUnit timeUnit) {
        this.poolAcquire.success(duration, timeUnit);
    }

    @Override
    public void onPoolAcquireStart() {
        this.poolAcquire.start();
    }

    @Override
    public void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.connectionClose.failure(duration, timeUnit);
    }

    @Override
    public void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        this.connectionClose.success(duration, timeUnit);
    }

    @Override
    public void onConnectionCloseStart() {
        this.connectionClose.start();
    }

    @Override
    public void onConnectFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.connection.failure(duration, timeUnit);
    }

    @Override
    public void onConnectSuccess(long duration, TimeUnit timeUnit) {
        this.connection.success(duration, timeUnit);
    }

    @Override
    public void onConnectStart() {
        this.connection.start();
    }
}

